<?php
/**
 * @package Tabaoca.Component.Gabble.Site
 * @subpackage com_gabble
 * @copyright (C) 2023 Jonatas C. Ferreira
 * @license GNU/AGPL v3 (see licence.txt)
 */

\defined('_JEXEC') or die;

use Joomla\CMS\Factory;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Uri\Uri;
use Joomla\CMS\Component\ComponentHelper;

$currentuser = Factory::getuser();
$document = Factory::getDocument();
$app = Factory::getApplication();
$session = $app->getSession();
$config = $app->getParams('com_gabble');

$cb_integration = $config->get('cb_integration');

if ($cb_integration && ComponentHelper::isEnabled('com_comprofiler')) {

	$profile = true;

} else {

	$profile = false;

}

$wa = $document->getWebAssetManager();
$wa->useScript('keepalive');

if (!$currentuser->get("id")) {

	$app->enqueueMessage(Text::_('JERROR_ALERTNOAUTHOR'), 'error');
	$app->setHeader('status', 403, true);

	return;

}

?>

<script language="JavaScript">

function addLoadEvent(func) {
	var oldonload = window.onload;
	if (typeof window.onload != 'function') {
			window.onload = func;
	} 
	else {
			window.onload = function() {
					if (oldonload) {
							oldonload();
					}
					func();
			}
		}
}

addLoadEvent(function(){setup_com();});

</script>

<div class="content">

	<div id="view_gabble" class="row">
	
		<div id="lists_gabble" class="col-md-4">

			<div id="select_list" class="row">

				<div class="col-md-6 notifications">
					<button id="list_chats" class="button_list" onclick="select_list(1);"><i class="icon-comments-2"></i><b> <?php echo Text::_('COM_GABBLE_CHATS');?></b></button>
					<div id="n_notifications" class="n-notifications" hidden=""></div>
				</div>
				<div class="col-md-6">
					<button id="list_users" class="button_list" onclick="select_list(2);"><i class="icon-users"></i><b> <?php echo Text::_('COM_GABBLE_USERS');?></b></button>
				</div>

			</div>

			<div id="options_list" hidden="">
				<select id="users_list" name="users_list" onchange="select_list(2);">
					<option value="0"><?php echo Text::_('COM_GABBLE_USERS_ON');?></option>
					<option value="1"><?php echo Text::_('COM_GABBLE_USERS_ALL');?></option>
				</select>
			</div>

			<div id="frame_list">
				<div id="users_frame" class="iframe_list" hidden="">
			</div>
				<div id="users_on_frame" class="iframe_list" hidden="">
			</div>
				<div id="feeds_frame" class="iframe_list">
				</div>
			</div>

			<div id="openai_btn" title="OpenAI GPT" onclick="open_user(0); event.stopPropagation();">
				<img src="<?php echo Uri::root() . "media/com_gabble/images/logo_openai.png"; ?>" alt="OpenAI GPT">
			</div>

		</div>

		<div id="windows_gabble" class="col-md-8">

			<div id="windows_list" class="row" hidden=""></div>

			<div id="frame_window"></div>

		</div>

	</div>

	<input type="hidden" id="gabble_type" value="com">
	<input type="hidden" id="uri_root" value="<?php echo Uri::root(); ?>">
	<input type="hidden" id="token" value="<?php echo $session->getFormToken(); ?>">
	<input type="hidden" id="user_id" value="<?php echo $currentuser->get("id"); ?>">
	<input type="hidden" id="gab_profile" value="<?php echo $profile; ?>">

	<input type="hidden" id="openai_gpt" value="<?php echo $config->get('openai_gpt'); ?>">
	<input type="hidden" id="openai_gpt_name" value="<?php echo $config->get('openai_gpt_name'); ?>">

</div>

<p style="text-align:right;" ><?php echo Text::_('COM_GABBLE_POWERED');?> <a href="https://tabaoca.org">Tabaoca</a></p>
