<?php
/**
 * @package Tabaoca.Component.Gabble.Site
 * @subpackage com_gabble
 * @copyright (C) 2023 Jonatas C. Ferreira
 * @license GNU/AGPL v3 (see licence.txt)
 */

namespace Tabaoca\Component\Gabble\Site\View\Gabble;

\defined('_JEXEC') or die;

use Joomla\CMS\MVC\View\HtmlView as BaseHtmlView;
use Joomla\CMS\Factory;
use Joomla\CMS\Language\Text;

class HtmlView extends BaseHtmlView {

	/**
	 * Display the Gabble Chat view
	 *
	 * @param   string  $tpl  The name of the template file to parse; automatically searches through the template paths.
	 *
	 * @return  void
	 */
	public function display($tpl = null) {

		$this->setDocument(null);

		//Display the view
		parent::display($tpl);

	}

	public function setDocument($doc): void {

		$document = Factory::getDocument();
		$document->setTitle(Text::_('COM_GABBLE_GABBLE_CHAT'));
		$document->addScript('media/com_gabble/js/gabble_com.js');
		$document->addStyleSheet('media/com_gabble/css/gabble.css');

		Text::script('COM_GABBLE_TIMEOUT');

	}

}
