<?php
/**
 * @package Tabaoca.Component.Gabble.Site
 * @subpackage com_gabble
 * @copyright (C) 2023 Jonatas C. Ferreira
 * @license GNU/AGPL v3 (see licence.txt)
 */

namespace Tabaoca\Component\Gabble\Site\Controller;

\defined('_JEXEC') or die;

use Joomla\CMS\MVC\Controller\BaseController;
use Joomla\CMS\Factory;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Session\Session;
use Joomla\CMS\Response\JsonResponse;

/**
 * Controller of Gabble Chat System component
 *
 * @package     Tabaoca.Component.Gabble.Site
 * @subpackage  com_gabble
 * @since       1.0.0
 */
class GabbleController extends BaseController {

	/**
	* Method to start the loop to refresh data.
	* 
	* @return  object  Response JSON encoded object to XHR call.
	* @since   1.0.0
	*/
	public function run () {

		try {

			if (!Session::checkToken()) {

				echo new JsonResponse(null, Text::_('JINVALID_TOKEN'), true);

			} else {

				$input = Factory::getApplication()->input;

				$n_users = $input->get('n_users', 0, 'INT');
				$n_users_on = $input->get('n_users_on', 0, 'INT');
				$n_feeds = $input->get('n_feeds', 0, 'INT');
				$n_notifications = $input->get('n_notifications', 0, 'INT');

				$model = $this->getModel();

				$record = $model->run($n_users, $n_users_on, $n_feeds, $n_notifications);

				echo new JsonResponse($record);

			}

		} catch (Exception $e) {

			echo new JsonResponse($e);

		}

	}

	/**
	* Method to populate opened chats when start.
	* 
	* @return  object  Response JSON encoded object to XHR call.
	* @since   1.0.0
	*/
	public function situation () {

		try {

			if (!Session::checkToken()) {

				echo new JsonResponse(null, Text::_('JINVALID_TOKEN'), true);

			} else {

				$model = $this->getModel();

				$record = $model->situation();

				echo new JsonResponse($record);

			}

		} catch (Exception $e) {

			echo new JsonResponse($e);

		}

	}

	/**
	* Method to open chat window by user id.
	* 
	* @return  object  Response JSON encoded object to XHR call.
	* @since   1.0.0
	*/
	public function open_user () {

		try {

			if (!Session::checkToken()) {

				echo new JsonResponse(null, Text::_('JINVALID_TOKEN'), true);

			} else {

				$input = Factory::getApplication()->input;

				$talkto_id = $input->get('talkto_id', 0, 'INT');

				$model = $this->getModel();

				$record = $model->open_user($talkto_id);

				echo new JsonResponse($record);

			}

		} catch (Exception $e) {

			echo new JsonResponse($e);

		}

	}

	/**
	* Method to open chat window by feed id.
	* 
	* @return  object  Response JSON encoded object to XHR call.
	* @since   1.0.0
	*/
	public function open_feed () {

		try {

			if (!Session::checkToken()) {

				echo new JsonResponse(null, Text::_('JINVALID_TOKEN'), true);

			} else {

				$input = Factory::getApplication()->input;

				$notification_id = $input->get('notification_id', 0, 'INT');

				$model = $this->getModel();

				$record = $model->open_feed($notification_id);

				echo new JsonResponse($record);

			}

		} catch (Exception $e) {

			echo new JsonResponse($e);

		}

	}

	/**
	* Method to close chat window.
	* 
	* @return  object  Response JSON encoded object to XHR call.
	* @since   1.0.0
	*/
	public function close_feed () {

		try {

			if (!Session::checkToken()) {

				echo new JsonResponse(null, Text::_('JINVALID_TOKEN'), true);

			} else {

				$input = Factory::getApplication()->input;

				$notification_id = $input->get('notification_id', 0, 'INT');

				$model = $this->getModel();

				$record = $model->close_feed($notification_id);

				echo new JsonResponse($record);

			}

		} catch (Exception $e) {

			echo new JsonResponse($e);

		}

	}

	/**
	* Method to minimize chat window.
	* 
	* @return  object  Response JSON encoded object to XHR call.
	* @since   1.0.0
	*/
	public function minimize_feed () {

		try {

			if (!Session::checkToken()) {

				echo new JsonResponse(null, Text::_('JINVALID_TOKEN'), true);

			} else {

				$input = Factory::getApplication()->input;

				$notification_id = $input->get('notification_id', 0, 'INT');

				$model = $this->getModel();

				$record = $model->minimize_feed($notification_id);

				echo new JsonResponse($record);

			}

		} catch (Exception $e) {

			echo new JsonResponse($e);

		}

	}

	/**
	* Method to activate chat window.
	* 
	* @return  object  Response JSON encoded object to XHR call.
	* @since   1.0.0
	*/
	public function activate_feed () {

		try {

			if (!Session::checkToken()) {

				echo new JsonResponse(null, Text::_('JINVALID_TOKEN'), true);

			} else {

				$input = Factory::getApplication()->input;

				$notification_id = $input->get('notification_id', 0, 'INT');

				$model = $this->getModel();

				$record = $model->activate_feed($notification_id);

				echo new JsonResponse($record);

			}

		} catch (Exception $e) {

			echo new JsonResponse($e);

		}

	}

	/**
	* Method to send message to chat.
	* 
	* @return  object  Response JSON encoded object to XHR call.
	* @since   1.0.0
	*/
	public function send_msg_feed () {

		try {

			if (!Session::checkToken()) {

				echo new JsonResponse(null, Text::_('JINVALID_TOKEN'), true);

			} else {

				$input = Factory::getApplication()->input;

				$notification_id = $input->get('notification_id', 0, 'INT');
				$feed_id = $input->get('feed_id', 0, 'INT');
				$message = $input->get('message', '', 'STRING');

				$model = $this->getModel();

				$record = $model->send_msg_feed($notification_id, $feed_id, $message, 0);

				echo new JsonResponse($record);

			}

		} catch (Exception $e) {

			echo new JsonResponse($e);

		}

	}

	/**
	* Method to send message to chat with OpenAi GPT Bot.
	* 
	* @return  object  Response JSON encoded object to XHR call.
	* @since   1.0.0
	*/
	public function send_msg_tobot () {

		try {

			if (!Session::checkToken()) {

				echo new JsonResponse(null, Text::_('JINVALID_TOKEN'), true);

			} else {

				$input = Factory::getApplication()->input;

				$notification_id = $input->get('notification_id', 0, 'INT');
				$feed_id = $input->get('feed_id', 0, 'INT');
				$message = $input->get('message', '', 'STRING');

				$model = $this->getModel();

				$record = $model->send_msg_tobot($notification_id, $feed_id, $message);

				echo new JsonResponse($record);

			}

		} catch (Exception $e) {

			echo new JsonResponse($e);

		}

	}


}
