/**
 * @package Tabaoca.Site
 * @subpackage com_gabble
 * @copyright (C) 2023 Jonatas C. Ferreira
 * @license GNU/AGPL v3 (see licence.txt)
 */

var n_users = 0,
	n_users_on = 0,
	n_feeds = 0,
	n_notifications = 0,
	active_id = 0;

var bot = 0;

var uri_root;
var currentUser;
var gab_profile;
var tk;


function setup_com () {

	uri_root = document.getElementById('uri_root').value;
	currentUser = document.getElementById('user_id').value;
	gab_profile = document.getElementById('gab_profile').value;
	tk = document.getElementById('token').value;

	select_list(1);

	if (document.getElementById('openai_gpt').value == 1) {

		document.getElementById('openai_btn').style.visibility = 'visible';

	} else {

		let b_openai = document.getElementById('openai_btn').parentNode;

		b_openai.removeChild(document.getElementById('openai_btn'));

	}

	data_feed('situation', null);

}

function run_com () {

	var myForm = new FormData();
	var xhr = new XMLHttpRequest(); 
	var url = uri_root + 'index.php?option=com_gabble&view=gabble&task=gabble.run&format=json';

	myForm.append(tk, 1);
	myForm.append('n_users', n_users);
	myForm.append('n_users_on', n_users_on);
	myForm.append('n_feeds', n_feeds);
	myForm.append('n_notifications', n_notifications);
        
	xhr.open("POST", url, true);

	xhr.onreadystatechange = function () {

								if (this.readyState == 4 && this.status == 200) {

									Jxhr = JSON.parse(xhr.response);

									if (Jxhr.data !== null) {

										if (Jxhr.data.users_on !== null) {

											n_users_on = Jxhr.data.users_on.n_users_on;
											n_users = Jxhr.data.users_on.n_users;
											populate_users_on(Jxhr.data.users_on.users);
											populate_users(Jxhr.data.users_on.users);
											refresh_online();

										}

										if (Jxhr.data.notifications !== null) {

											let n = 0;
											let x = 0;

											active_id = Jxhr.data.active_id;
											n_feeds = Jxhr.data.notifications.length;
											populate_feeds(Jxhr.data.notifications, Jxhr.data.cb_users);
											refresh_online();

											for (let i = 0; i < Jxhr.data.notifications.length; i++) {

												n = n + Jxhr.data.notifications[i].n_notifications;

												if (Jxhr.data.notifications[i].n_notifications) {

													x++;

													if (Jxhr.data.notifications[i].w_open) {

														document.getElementById('n_' + Jxhr.data.notifications[i].id).removeAttribute('hidden');
														document.getElementById('n_' + Jxhr.data.notifications[i].id).innerHTML = Jxhr.data.notifications[i].n_notifications;

														if (document.getElementById('gabble_type').value == 'mod') {

															document.getElementById('ln_' + Jxhr.data.notifications[i].id).removeAttribute('hidden');
															document.getElementById('ln_' + Jxhr.data.notifications[i].id).innerHTML = Jxhr.data.notifications[i].n_notifications;

														}

													}

												}

											}

											n_notifications = n;

											if (x) {

												document.getElementById('n_notifications').innerHTML = `${x}`;
												document.getElementById('n_notifications').removeAttribute('hidden');

											} else {

												document.getElementById("n_notifications").hidden = true;

											}
											
										}

										if (Jxhr.data.active_id) {

											if (Jxhr.data.msgs !== null) {

												if (document.getElementById('gabble_type').value == 'com') {

													let iframe = document.getElementById("fwin_" + Jxhr.data.active_id);

													document.getElementById('win_'+ Jxhr.data.active_id).dataset.read_id = Jxhr.data.msgs[Jxhr.data.msgs.length - 1].id;
													iframe.innerHTML += populate_messages(Jxhr.data.active_id, Jxhr.data.msgs);

													document.getElementById('n_' + Jxhr.data.active_id).hidden = true;

												} else if (document.getElementById('gabble_type').value == 'mod') {

													let iframe = document.getElementById("fwin_" + Jxhr.data.active_id);

													document.getElementById('win_'+ Jxhr.data.active_id).dataset.read_id = Jxhr.data.msgs[Jxhr.data.msgs.length - 1].id;
													iframe.innerHTML += populate_messages(Jxhr.data.active_id, Jxhr.data.msgs);

													document.getElementById('n_' + Jxhr.data.active_id).hidden = true;
													document.getElementById('ln_' + Jxhr.data.active_id).hidden = true;

												}

											}

										}

										setTimeout(function () { run_com();}, 0);

									} else {

										alert(Joomla.JText._('COM_GABBLE_TIMEOUT'));
										location.reload();

									}

								}

							}

	xhr.send(myForm);

}

function data_feed (command, arguments) {

	var myForm = new FormData(),
		xhr = new XMLHttpRequest(),
		url = uri_root + 'index.php?option=com_gabble&view=gabble&task=gabble.'+ command +'&format=json';

	myForm.append(tk, 1);
	myForm.append('command', command);

	if (arguments !== null) {

		myForm.append('notification_id', arguments.notification_id);

	}

	switch (command) {

		case 'open_user':

			myForm.append('talkto_id', arguments.talkto_id);
		
			break;

		case 'send_msg_feed':

			myForm.append('feed_id', arguments.feed_id);
			myForm.append('message', encodeURIComponent(arguments.message));

			break;

		case 'send_msg_tobot':

			myForm.append('feed_id', arguments.feed_id);
			myForm.append('message', encodeURIComponent(arguments.message));

			break;

	}

	xhr.open("POST", url, true);

	xhr.onreadystatechange = function () {

								if (this.readyState == 4 && this.status == 200) {

									Jxhr = JSON.parse(xhr.response);

									if (Jxhr.data !== null) {

										switch (command) {

											case 'situation':

												if (Jxhr.data.n) {

													populate_windows(Jxhr.data.feeds);

												}

												run_com();

												break;

											case 'open_user':

												if (Jxhr.data.n) {

													open_feed(Jxhr.data.notification[0].id);

												}

												break;

											case 'open_feed':

												if (Jxhr.data.n) {

													if (document.getElementById('gabble_type').value == 'com') {

														if (document.getElementById('windows_list').hidden) {

															document.getElementById('windows_list').removeAttribute('hidden');

														}

														window_open(Jxhr.data.notification[0]);

													} else {

														window_create(Jxhr.data.notification[0]);

													}

													window_activate(Jxhr.data.notification[0].id);

													document.getElementById('fwin_' + Jxhr.data.notification[0].id).scrollTo(0, document.getElementById('fwin_' + Jxhr.data.notification[0].id).scrollHeight);

													document.getElementById("btn_"+ Jxhr.data.notification[0].id).dataset.open = 1;

												}

												break;

											case 'minimize_feed':

												let m_win = document.getElementById('win_'+ Jxhr.data.id);
												let m_list = document.getElementById('list_'+ Jxhr.data.id);

												if (m_win.hasAttribute('hidden')) {

													m_win.removeAttribute('hidden');
													m_list.hidden = true;

													window_activate(Jxhr.data.id);

												} else {

													m_win.hidden = true;
													m_list.removeAttribute('hidden');

												}

												break;

											case 'close_feed':

												if (document.getElementById('gabble_type').value == 'com') {

													let c_win = document.getElementById('bwin_div_'+ Jxhr.data.notification[0].id).parentNode;
													let c_list = document.getElementById('win_'+ Jxhr.data.notification[0].id).parentNode;

													document.getElementById('win_'+ Jxhr.data.notification[0].id).dataset.roll = 0;

													c_win.removeChild(document.getElementById('bwin_div_'+ Jxhr.data.notification[0].id));
													c_list.removeChild(document.getElementById('win_'+ Jxhr.data.notification[0].id));

													document.getElementById("btn_"+ Jxhr.data.notification[0].id).dataset.open = 0;

													if (document.getElementById('windows_list').innerHTML == '') {

														document.getElementById('windows_list').hidden = true;

													}

												} else {

													let c_win = document.getElementById('win_'+ Jxhr.data.notification[0].id).parentNode;
													let c_list = document.getElementById('list_'+ Jxhr.data.notification[0].id).parentNode;

													document.getElementById('win_'+ Jxhr.data.notification[0].id).dataset.roll = 0;

													c_win.removeChild(document.getElementById('win_'+ Jxhr.data.notification[0].id));
													c_list.removeChild(document.getElementById('list_'+ Jxhr.data.notification[0].id));

													document.getElementById("btn_"+ Jxhr.data.notification[0].id).dataset.open = 0;

												}

												if (Jxhr.data.notification[0].id == active_id) {

													active_id = 0;

												}

												break;

											case 'activate_feed':

												let users = JSON.parse(Jxhr.data.notification[0].users_ids);

												if (users.includes(0)) {

													bot = 1;

												} else {

													bot = 0;

												}

												if (active_id) {

													if (Jxhr.data.notification[0].id != active_id) {

														if (document.getElementById('gabble_type').value == 'com') {

															document.getElementById('bwin_' + Jxhr.data.notification[0].id).className = "window_list_s";
															document.getElementById('bwin_' + active_id).className = "window_list";

															document.getElementById('win_' + Jxhr.data.notification[0].id).removeAttribute('hidden');
															document.getElementById('win_' + active_id).hidden = true;

															document.getElementById('n_' + Jxhr.data.notification[0].id).hidden = true;

														} else {

															document.getElementById('win_' + Jxhr.data.notification[0].id + '_header').style.background = "#F44321";
															
															if (document.getElementById('win_' + active_id + '_header') !== null) {

																document.getElementById('win_' + active_id + '_header').style.background = "#5091CD";
															
															}

															document.getElementById('n_' + Jxhr.data.notification[0].id).hidden = true;
															document.getElementById('ln_' + Jxhr.data.notification[0].id).hidden = true;

														}

													}

													document.getElementById('fwin_' + active_id).scrollTo(0, document.getElementById('fwin_' + active_id).scrollHeight);

												} else {

													if (document.getElementById('gabble_type').value == 'com') {

														document.getElementById('bwin_' + Jxhr.data.notification[0].id).className = "window_list_s";
														document.getElementById('win_' + Jxhr.data.notification[0].id).removeAttribute('hidden');

														document.getElementById('n_' + Jxhr.data.notification[0].id).hidden = true;

													} else {

														document.getElementById('win_' + Jxhr.data.notification[0].id + '_header').style.background = "#F44321";

														document.getElementById('n_' + Jxhr.data.notification[0].id).hidden = true;
														document.getElementById('ln_' + Jxhr.data.notification[0].id).hidden = true;

													}

												}

												document.getElementById('fwin_' + Jxhr.data.notification[0].id).scrollTo(0, document.getElementById('fwin_' + Jxhr.data.notification[0].id).scrollHeight);
												active_id = Jxhr.data.notification[0].id;

												break;

											case 'send_msg_feed':

												break;

											case 'send_msg_tobot':

												let iframe = document.getElementById("fwin_" + Jxhr.data.notification_id);

												if (Jxhr.data.bot_error) {

													iframe.innerHTML += `<div class="openai_error">
																				<i class="icon-joomla"></i> The connection to OpenAI was not established.
																			</div>`;

												}

												document.getElementById('openai_logo_anim').hidden = true;

												break;

										}

									} else {

										alert(Joomla.JText._('COM_GABBLE_TIMEOUT'));
										location.reload();

									}

								}

							}

	xhr.send(myForm);

}

function open_user (talkto_id) {

	let args = new Object();

	args.talkto_id = talkto_id;

	data_feed('open_user', args);

}

function open_feed (notification_id) {

	let args = new Object();

	args.notification_id = notification_id;

	if (document.getElementById("btn_"+ notification_id).dataset.open != 0) {

		if (document.getElementById('gabble_type').value == 'com') {

			window_activate(notification_id);

		} else {

			if (document.getElementById('win_'+ notification_id).hasAttribute('hidden')) {

				window_minimize(notification_id);

			} else {

				window_activate(notification_id);

			}

		}

	} else {

		data_feed('open_feed', args);

	}

}

function window_activate (notification_id) {

	var args = new Object();

	args.notification_id = notification_id;

	if (notification_id != active_id) {

		data_feed('activate_feed', args);

	}

}

function window_minimize (notification_id) {

	let args = new Object();

	args.notification_id = notification_id;

	data_feed('minimize_feed', args);

}

function window_close (notification_id) {

	let args = new Object();

	args.notification_id = notification_id;

	data_feed('close_feed', args);

}

function send_message (notification_id) {

	let args = new Object();

	args.feed_id = document.getElementById('win_' + notification_id).dataset.feed_id;
	args.message = document.getElementById('message_' + notification_id).value;
	args.notification_id = notification_id;

	if (args.message.trim().length === 0) {

		clear_box_msg(notification_id);
		verify_msg_send(notification_id);

	} else {

		data_feed('send_msg_feed', args);

		clear_box_msg(notification_id);
		verify_msg_send(notification_id);

	}

	if (!document.getElementById('emojis_' + notification_id).hasAttribute('hidden')) {

		document.getElementById('emojis_' + notification_id).hidden = true;

	}

}

function send_message_tobot (notification_id) {

	let args = new Object();

	document.getElementById('openai_logo_anim').removeAttribute('hidden');

	args.feed_id = document.getElementById('win_' + notification_id).dataset.feed_id;
	args.message = document.getElementById('message_' + notification_id).value;
	args.notification_id = notification_id;

	if (args.message.trim().length === 0) {

		clear_box_msg(notification_id);
		verify_msg_send(notification_id);

	} else {

		data_feed('send_msg_tobot', args);
		clear_box_msg(notification_id);
		verify_msg_send(notification_id);

	}

	if (!document.getElementById('emojis_' + notification_id).hasAttribute('hidden')) {

		document.getElementById('emojis_' + notification_id).hidden = true;

	}

}

function populate_windows (feeds) {

	var i;

	for (i = 0; i < feeds.length; i++) {

		if (document.getElementById('gabble_type').value == 'com') {

			if (document.getElementById('windows_list').hidden) {

				document.getElementById('windows_list').removeAttribute('hidden');

			}

			window_open(feeds[i]);

		} else {

			window_create(feeds[i]);

		}

		if (feeds[i].active == 1) {

			window_activate(feeds[i].id);

		}

	}

}

function window_open (feed) {

	var msgs = '';
	var n_notif = 0;
	var n_hidden = '';
	var w_hidden = 'hidden';
	var users = JSON.parse(feed.users_ids);
	var feed_name = JSON.parse(feed.feed_name);

	var title; 
	var titleb = [];
	var feed_name = JSON.parse(feed.feed_name);
	var avatar = [];
	var avatarb;

	for (j = 0; j < feed_name.length; j++) {

		if (feed_name[j].id == 0) {

			title = `<img src="${uri_root}media/com_gabble/images/logo_openai.png" class="openai_logo_sm" alt="OpenAI GPT"><span>${feed_name[j].username}</span>`;

		} else {

			if (gab_profile && feed_name[j].avatar) {

				avatar =  feed_name[j].avatar.split('/');

				if (avatar[0] == 'gallery') {

					avatarb = uri_root + 'images/comprofiler/' + feed_name[j].avatar;

				} else {

					avatarb = uri_root + 'images/comprofiler/tn' + feed_name[j].avatar;

				}

				title = `<img class="gab-avatar" src="${avatarb}" alt="${feed_name[j].username}" title="${feed_name[j].username}" class=""><span>${feed_name[j].username}</span>`;
	
			} else {
				
				title = `<i class="icon-user gab-no-avatar"></i><span>${feed_name[j].username}</span>`;

			}

		}

		titleb.push(title);

	}

	title = titleb.join(', ');

	if (feed.n_notifications) {

		n_hidden = '';
		n_notif = feed.n_notifications;

	} else {

		n_hidden = 'hidden';

	}

	var window_button = `<div id="bwin_div_${feed.id}" name="bwin_div" class="col-md-4" data-users="${feed.users_ids}" data-id="${feed.id}">
						<div id="bwin_${feed.id}" class="window_list notifications" onclick="window_activate(${feed.id});" >
							<div id="window_title" class="window-title-com"><b>${title}</b></div>
							<div id="btn_exit" class="button-mod gab-btn" onclick="window_close(${feed.id}); event.stopPropagation();">
								<i class="icon-delete"></i>
							</div>
							<div id="n_${feed.id}" class="n-notifications" ${n_hidden}>${n_notif}</div>
							<div id="btn_on_${feed.id}" class="btn_on_com" hidden=""></div>
						 </div>
					  </div>`;

	var window_frame = `<div id="win_${feed.id}" class="window-com" onclick="window_activate(${feed.id});" ${w_hidden} data-read_id="${feed.read_id}" data-feed_id="${feed.feed_id}" data-roll="1">
							<div id="win_${feed.id}_header" class="window-header-com">
								<div id="window_title" class="window-title">${title}</div>
								<div id="btn_exit" class="button-mod gab-btn" onclick="window_close(${feed.id}); event.stopPropagation();">
									<i class="icon-delete"></i>
								</div>
							</div>
							<div id="win_content_${feed.id}" class="window-content">
								<div id="fwin_${feed.id}" name="fwin_${feed.id}" style="width:100%; height:100%; overflow: auto;">
								</div>
							</div>
							<div id="footer_${feed.id}" class="content-footer" style="display:flex;">
								<input id="message_${feed.id}" class="msg-input" maxlength="512">
								<div class="icon-smiley input_emoji" onclick="show_emojis(${feed.id});"></div>
								<div id="emojis_${feed.id}" class="emojis_div" hidden=""></div>
								<div id="btn_send_${feed.id}" class="button-mod msg-button-off"></div>
							</div>
					  </div>`;

	document.getElementById('windows_list').innerHTML += window_button;
	document.getElementById('frame_window').innerHTML += window_frame;

	if (feed.msgs !== null) {

		msgs = populate_messages(feed.id, feed.msgs);

	}

	document.getElementById('fwin_' + feed.id).innerHTML = msgs;

	document.getElementById('fwin_' + feed.id).setAttribute('onmousemove', `document.getElementById('win_${feed.id}').dataset.roll = 0;`);
	document.getElementById('fwin_' + feed.id).setAttribute('onmouseleave', `document.getElementById('win_${feed.id}').dataset.roll = 1; roll_frame_feed(${feed.id});`);

	document.getElementById('message_' + feed.id).setAttribute('onkeyup', `verify_msg_send(${feed.id});`);
	document.getElementById('message_' + feed.id).setAttribute('onkeydown', `verify_msg_send(${feed.id});`);

	if (users.includes(0)) {

		document.getElementById('win_content_' + feed.id).innerHTML += `<div id="openai_logo_anim" hidden=""><object id="openai_logo2" type="image/svg+xml" data="${uri_root}media/com_gabble/images/logo_openai_anim.svg"></object></div>`;
		document.getElementById('message_' + feed.id).setAttribute('onkeypress', `verify_msg_send(${feed.id}); if (event.keyCode == 13){ event.preventDefault(); send_message_tobot(${feed.id});}`);

		if (document.getElementById('openai_gpt').value == 0) {

			roll_frame_feed(feed.id);
			document.getElementById('footer_' + feed.id).innerHTML = `<div><i class="icon-joomla"></i> OpenAI API Chat is disable.</div>`;

		} else {

			roll_frame_feed(feed.id);
			document.getElementById('message_' + feed.id).focus();
			verify_msg_send(feed.id);

		}

	} else {

		
		roll_frame_feed(feed.id);
		document.getElementById('message_' + feed.id).focus();
		verify_msg_send(feed.id);
		document.getElementById('message_' + feed.id).setAttribute('onkeypress', `verify_msg_send(${feed.id}); if (event.keyCode == 13){ event.preventDefault(); send_message(${feed.id});}`);

	}

}

function window_create (feed) {

	var html;
	var w_hidden;
	var l_hidden;
	var msgs = '';
	var users = JSON.parse(feed.users_ids);
	var title;
	var titleb = [];
	var feed_name = JSON.parse(feed.feed_name);
	var avatar = [];
	var avatarb;


	var char = feed.feed_name.charAt(0);

	char = char.toUpperCase();

	var n_hidden = '';
	var ln_hidden = '';
	var n_notif = 0;

	for (j = 0; j < feed_name.length; j++) {

		if (feed_name[j].id == 0) {

			title = `<img src="${uri_root}media/com_gabble/images/logo_openai.png" class="openai_logo_sm" alt="OpenAI GPT"><span>${feed_name[j].username}</span>`;
			char = `<img src="${uri_root}media/com_gabble/images/logo_openai.png" class="openai_logo_md" alt="OpenAI GPT">`;

		} else {

			if (gab_profile && feed_name[j].avatar) {

				avatar =  feed_name[j].avatar.split('/');

				if (avatar[0] == 'gallery') {

					avatarb = uri_root + 'images/comprofiler/' + feed_name[j].avatar;

				} else {

					avatarb = uri_root + 'images/comprofiler/tn' + feed_name[j].avatar;

				}

				title = `<img class="gab-avatar" src="${avatarb}" alt="${feed_name[j].username}" title="${feed_name[j].username}" class=""><span>${feed_name[j].username}</span>`;
				char = `<img class="gab-avatar-item" src="${avatarb}" alt="${feed_name[j].username}" title="${feed_name[j].username}" class="">`;
	
			} else {
				
				title = `<i class="icon-user gab-no-avatar"></i><span>${feed_name[j].username}</span>`;
				char = char.toUpperCase();

			}

		}

		titleb.push(title);

	}

	title = titleb.join(', ');

	if (feed.w_open == 1) {

		w_hidden = '';
		l_hidden = 'hidden';

	} else if (feed.w_open == 2) {

		w_hidden = 'hidden';
		l_hidden = '';

	}

	if (feed.n_notifications) {

		n_hidden = '';
		ln_hidden = '';
		n_notif = feed.n_notifications;

	} else {

		n_hidden = 'hidden';
		ln_hidden = 'hidden';

	}

	html = `<div id="win_${feed.id}" name="win_feed" class="window" onclick="window_activate(${feed.id});" ${w_hidden} data-read_id="${feed.read_id}" data-feed_id="${feed.feed_id}" data-roll="1" data-users="${feed.users_ids}" data-id="${feed.id}">
				<div id="win_${feed.id}_header" class="window-header notifications">
					<div id="window_title" class="window-title">${title}</div>
					<div id="btn_exit" class="button-mod gab-btn" onclick="window_close(${feed.id}); event.stopPropagation();">
						<i class="icon-delete"></i>
					</div>
					<div id="btn_min" class="button-mod gab-btn" onclick="window_minimize(${feed.id}); event.stopPropagation();">
						<i class="icon-minus-2"></i>
					</div>
					<div id="n_${feed.id}" class="m-notifications" ${n_hidden}>${n_notif}</div>
					<div id="btn_on_${feed.id}" class="btn_on_mod" hidden=""></div>
				</div>
				<div id="win_content_${feed.id}" class="window-content">
					<div id="fwin_${feed.id}" name="fwin_${feed.id}" style="width:100%; height:100%; overflow: auto;">
					</div>
				</div>
				<div id="footer_${feed.id}" class="content-footer" style="display:flex;">
					<input id="message_${feed.id}" class="msg-input" maxlength="512">
					<div class="icon-smiley input_emoji" onclick="show_emojis(${feed.id});"></div>
					<div id="emojis_${feed.id}" class="emojis_div" hidden=""></div>
					<div id="btn_send_${feed.id}" class="button-mod msg-button-off"></div>
				</div>
			</div>`;

	item_list = `<div id="list_${feed.id}" class="button-mod item-list notifications" onclick="window_minimize(${feed.id});" title="${feed.feed_name}" ${l_hidden}>
					<div id="ln_${feed.id}" class="n-notifications" ${ln_hidden}>${n_notif}</div>
					<div id="btn2_on_${feed.id}" class="btn_on_mod" hidden=""></div>
					${char}
				 </div>`;

	document.getElementById('main_windows').innerHTML += html;
	document.getElementById('list_windows').innerHTML += item_list;

	if (feed.msgs !== null) {

		msgs = populate_messages(feed.id, feed.msgs);

	}

	document.getElementById('fwin_' + feed.id).innerHTML = msgs;

	document.getElementById('message_' + feed.id).setAttribute('onkeyup', `verify_msg_send(${feed.id});`);
	document.getElementById('message_' + feed.id).setAttribute('onkeydown', `verify_msg_send(${feed.id});`);

	document.getElementById('fwin_' + feed.id).setAttribute('onmousemove', `document.getElementById('win_${feed.id}').dataset.roll = 0;`);
	document.getElementById('fwin_' + feed.id).setAttribute('onmouseleave', `document.getElementById('win_${feed.id}').dataset.roll = 1; roll_frame_feed(${feed.id});`);

	if (users.includes(0)) {

		document.getElementById('win_content_' + feed.id).innerHTML += `<div id="openai_logo_anim" hidden=""><object id="openai_logo2" type="image/svg+xml" data="${uri_root}media/com_gabble/images/logo_openai_anim.svg"></object></div>`;
		document.getElementById('message_' + feed.id).setAttribute('onkeypress', `verify_msg_send(${feed.id}); if (event.keyCode == 13){ event.preventDefault(); send_message_tobot(${feed.id});}`);

		if (document.getElementById('openai_gpt').value == 0) {

			roll_frame_feed(feed.id);
			document.getElementById('footer_' + feed.id).innerHTML = `<div><i class="icon-joomla"></i> OpenAI API Chat is disable.</div>`;

		} else {

			roll_frame_feed(feed.id);
			document.getElementById('message_' + feed.id).focus();
			verify_msg_send(feed.id);

		}

	} else {

		roll_frame_feed(feed.id);
		document.getElementById('message_' + feed.id).focus();
		verify_msg_send(feed.id);
		document.getElementById('message_' + feed.id).setAttribute('onkeypress', `verify_msg_send(${feed.id}); if (event.keyCode == 13){ event.preventDefault(); send_message(${feed.id});}`);

	}

}

function select_list (frame_type) {

	if (frame_type == 1) {

		document.getElementById('list_chats').className = 'button_list_s';
		document.getElementById('list_users').className = 'button_list';
		document.getElementById('users_frame').hidden = true;
		document.getElementById('users_on_frame').hidden = true;
		document.getElementById('feeds_frame').removeAttribute('hidden');

		document.getElementById('options_list').hidden = true;

	} else if (frame_type == 2) {

		document.getElementById('list_chats').className = 'button_list';
		document.getElementById('list_users').className = 'button_list_s';
		document.getElementById('feeds_frame').hidden = true;

		if (document.getElementById('users_list').value == 0) {

			document.getElementById('users_on_frame').removeAttribute('hidden');
			document.getElementById('users_frame').hidden = true;

		} else {

			document.getElementById('users_frame').removeAttribute('hidden');
			document.getElementById('users_on_frame').hidden = true;

		}

		document.getElementById('options_list').removeAttribute('hidden');

	}

}

function populate_users (users) {

	var html = '';
	var iframe_menu = document.getElementById("users_frame"); 
	var title;
	var avatar = [];
	var avatarb;

	if (users.length) {

		for (i = 0; i < users.length; i++) {

			if (users[i].id != currentUser) {

				if (users[i].online) {

					cl = 'gab-user-on';

				} else {

					cl = 'gab-feed';

				}

				if (gab_profile && users[i].avatar) {

					avatar =  users[i].avatar.split('/');

					if (avatar[0] == 'gallery') {

						avatarb = uri_root + 'images/comprofiler/' + users[i].avatar;

					} else {

						avatarb = uri_root + 'images/comprofiler/tn' + users[i].avatar;

					}
	
					title = `<img class="gab-avatar" src="${avatarb}" alt="${users[i].username}" title="${users[i].username}"><a href="${uri_root}index.php/cb-profile/${users[i].username}" target="_blank"><span>${users[i].username}</span></a>`;
		
				} else {
					
					title = `<i class="icon-user gab-no-avatar"></i><span>${users[i].username}</span>`;
					
				}

				html += `<div class="${cl}" onclick="open_user(${users[i].id},'${users[i].username}');">
							${title}
						</div>`;

			}

		}

	} else {

		html = `<div class="gab-feed style="color: #f44321;">
					No Users.
				</div>`;

	}

	iframe_menu.innerHTML = html;

}

function populate_users_on (users) {

	var html = '';
	var iframe_menu = document.getElementById("users_on_frame"); 
	var x = 0;
	var title;
	var avatar = [];
	var avatarb;

	if (users.length) {

		for (i = 0; i < users.length; i++) {

			if (users[i].id != currentUser) {

				if (users[i].online == 1) {

					x++;

					if (gab_profile && users[i].avatar) {

						avatar =  users[i].avatar.split('/');
	
						if (avatar[0] == 'gallery') {
	
							avatarb = uri_root + 'images/comprofiler/' + users[i].avatar;
	
						} else {
	
							avatarb = uri_root + 'images/comprofiler/tn' + users[i].avatar;
	
						}
		
						title = `<img class="gab-avatar" src="${avatarb}" alt="${users[i].username}" title="${users[i].username}"><a href="${uri_root}index.php/cb-profile/${users[i].username}" target="_blank"><span>${users[i].username}</span></a>`;
			
					} else {
						
						title = `<i class="icon-user gab-no-avatar"></i><span>${users[i].username}</span>`;
		
					}

					html += `<div name="user_on_list" class="gab-user-on" data-user_id="${users[i].id}" onclick="open_user(${users[i].id},'${users[i].username}');">
								${title}
							</div>`;

				}

			}

		}

		if (!x) {

			html = `<div class="gab-feed" style="color: #f44321;">
						No Users Online.
					</div>`;

		}

	} else {

		html = `<div class="gab-feed" style="color: #f44321;">
						No Users Online.
					</div>`;

	}

	iframe_menu.innerHTML = html;

}

function populate_feeds (feeds, cb_users) {

	var html = '';

	var iframe_menu = document.getElementById("feeds_frame");

	if (feeds.length) {

	
		for (i = 0; i < feeds.length; i++) {

			let n = '';
			let title; 
			var titleb = [];
			var avatar;
			let feed_name = JSON.parse(feeds[i].feed_name);

			for (j = 0; j < feed_name.length; j++) {

				if (feed_name.id != currentUser) {
				
					if (feed_name[j].id == 0) {

						title = `<img src="${uri_root}media/com_gabble/images/logo_openai.png" class="openai_logo_sm" alt="OpenAI GPT"><span>${feed_name[j].username}</span>`;

					} else {

						if (gab_profile && feed_name[j].avatar) {

							if (feed_name[j].avatar.startsWith('gallery')) {

								avatar = uri_root + 'images/comprofiler/' + feed_name[j].avatar;

							} else {

								avatar = uri_root + 'images/comprofiler/tn' + feed_name[j].avatar;

							}

							title = `<img class="gab-avatar" src="${avatar}" alt="${feed_name[j].username}" title="${feeds[i].username}" class=""><a href="${uri_root}index.php/cb-profile/${feed_name[j].username}" target="_blank"><span>${feed_name[j].username}</span></a>`;
				
						} else {
							
							title = `<i class="icon-user gab-no-avatar"></i><span>${feed_name[j].username}</span>`;
			
						}

					}

					titleb.push(title);

				}

			}

			title = titleb.join(', ');

			if (feeds[i].n_notifications) {

				n = `<div class="n-notifications">${feeds[i].n_notifications}</div>`;

			}

			html += `<div id="btn_${feeds[i].id}"
						name="feed_list"
						class="gab-feed"
						data-users="${feeds[i].users_ids}"
						data-open="${feeds[i].w_open}"
						onclick="open_feed(${feeds[i].id})">
						 
						<div class="notifications">
							${title}
							${n}
						</div>
					 </div>`;

		} 

	} else {

		html = `<div class="gab-feed">
					<div class="gab-user" style="color: #f44321;">
						No chats.
					</div>
				</div>`;

	}

	iframe_menu.innerHTML = html;

}

function populate_messages (notification_id, msgs) {

	var print_msgs = '';
	var type;
	var i;
	var title;
	var avatar = [];
	var avatarb;

	read_id = document.getElementById('win_'+ notification_id).dataset.read_id;

	if (msgs.length > 0) {

		for (i = 0; i < msgs.length; i++) {

			if (msgs[i].user_id == currentUser) {

				type = 'gab-self';
				username = msgs[i].username;

			} else if (msgs[i].user_id == 0) {

				type = 'gab-bot';

				if (document.getElementById('openai_gpt_name').value == '') {

					username = 'Gabble Bot';

				} else {

					username = document.getElementById('openai_gpt_name').value;

				}

			} else {

				type = 'gab-others';
				username = msgs[i].username;

			}

			if (gab_profile && msgs[i].avatar) {

				avatar =  msgs[i].avatar.split('/');

				if (avatar[0] == 'gallery') {

					avatarb = uri_root + 'images/comprofiler/' + msgs[i].avatar;

				} else {

					avatarb = uri_root + 'images/comprofiler/tn' + msgs[i].avatar;

				}

				title = `<img class="gab-avatar" src="${avatarb}" alt="${msgs[i].username}" title="${msgs[i].username}" class=""><span>${msgs[i].username}</span>`;
	
			} else {
				
				title = `<i class="icon-user gab-no-avatar"></i><span>${msgs[i].username}</span>`;

			}

			print_msgs +=  `<div class="${type}">
								<div>
									<spam class="gab-msghead" title="${msgs[i].sended}">
										${title}
									</spam>
								</div>
								<div class="gab-msg">
									${msgs[i].message}
								</div>
							</div>`;

		}

	}

	return print_msgs;

}

function refresh_online () {

	var feeds = document.getElementsByName('feed_list');
	var users = document.getElementsByName('user_on_list');

	for (let i = 0; i < feeds.length; i++) {

		let feed_users = JSON.parse(feeds[i].dataset.users);

		if (users.length) {

			for (let n = 0; n < users.length; n++) {

				if (feed_users.includes(parseInt(users[n].dataset.user_id))) {

					feeds[i].className = 'gab-user-on';

				} else {

					feeds[i].className = 'gab-feed';

				}

			}

		} else {

			feeds[i].className = 'gab-feed';

		}

	}
	
	if (document.getElementById('gabble_type').value == 'com') {

		var btns = document.getElementsByName('bwin_div'); 

		if (btns.length) {

			for (let i = 0; i < btns.length; i++) {

				let btn_users = JSON.parse(btns[i].dataset.users);
				let btn_id = btns[i].dataset.id;

				if (users.length) {

					for (let n = 0; n < users.length; n++) {

						if (btn_users.includes(parseInt(users[n].dataset.user_id))) {

							document.getElementById('btn_on_' + btn_id).removeAttribute('hidden');

						} else {

							document.getElementById('btn_on_' + btn_id).hidden = true;

						}

					}

				} else {

					document.getElementById('btn_on_' + btn_id).hidden = true;

				}

			}

		}

	} else if (document.getElementById('gabble_type').value == 'mod') {

		var btns = document.getElementsByName('win_feed'); 

		if (btns.length) {

			for (let i = 0; i < btns.length; i++) {

				let btn_users = JSON.parse(btns[i].dataset.users);
				let btn_id = btns[i].dataset.id;

				if (users.length) {

					for (let n = 0; n < users.length; n++) {

						if (btn_users.includes(parseInt(users[n].dataset.user_id))) {

							document.getElementById('btn_on_' + btn_id).removeAttribute('hidden');
							document.getElementById('btn2_on_' + btn_id).removeAttribute('hidden');

						} else {

							document.getElementById('btn_on_' + btn_id).hidden = true;
							document.getElementById('btn2_on_' + btn_id).hidden = true;

						}

					}

				} else {

					document.getElementById('btn_on_' + btn_id).hidden = true;
					document.getElementById('btn2_on_' + btn_id).hidden = true;

				}

			}

		}

	}

}

function roll_frame_feed (notification_id) { 

	var win = document.getElementById('win_'+ notification_id);

	if (win !== null) {

		if (win.dataset.roll == 1){

			document.getElementById('fwin_'+ notification_id).scrollBy({top: 70, left: 0, behavior: "smooth"});
			setTimeout(function () {roll_frame_feed(notification_id);}, 50);

		}

	}

}

function verify_msg_send (notification_id) {

	var text_box = document.getElementById('message_' + notification_id);

	if (text_box.value != '') {

		document.getElementById('btn_send_' + notification_id).innerHTML = '<i class="icon-ok"></i>';
		document.getElementById('btn_send_' + notification_id).className = 'button-mod msg-button-on';

		if (bot) {

			document.getElementById('btn_send_' + notification_id).onclick = function () {send_message_tobot(notification_id);};

		} else {

			document.getElementById('btn_send_' + notification_id).onclick = function () {send_message(notification_id);};

		}

	} else {

		document.getElementById('btn_send_' + notification_id).innerHTML = '<i class="icon-ok"></i>';
		document.getElementById('btn_send_' + notification_id).className = 'msg-button-off';
		document.getElementById('btn_send_' + notification_id).onclick = function () {};

	}

}

function clear_box_msg(notification_id) {

	document.getElementById('message_' + notification_id).value = '';
	document.getElementById('message_' + notification_id).focus();

}

function insert_emoji(notification_id, text) {

	var el = document.getElementById('message_' + notification_id);
	var val = el.value, endIndex, range;

	if (typeof el.selectionStart != "undefined" && typeof el.selectionEnd != "undefined") {

		endIndex = el.selectionEnd;
		el.value = val.slice(0, el.selectionStart) + text + val.slice(endIndex);
		el.selectionStart = el.selectionEnd = endIndex + text.length;

	} else if (typeof document.selection != "undefined" && typeof document.selection.createRange != "undefined") {

		el.focus();
		range = document.selection.createRange();
		range.collapse(false);
		range.text = text;
		range.select();

	}

	verify_msg_send(notification_id);
	document.getElementById('message_' + notification_id).focus();

}

function show_emojis (notification_id) {

	var div = document.getElementById('emojis_' + notification_id);

	var emojis = `<table><tr>
					<td class="emoji" onclick="insert_emoji(${notification_id}, '&#128512');">&#128512</td>
					<td class="emoji" onclick="insert_emoji(${notification_id}, '&#128518');">&#128518</td>
					<td class="emoji" onclick="insert_emoji(${notification_id}, '&#128521');">&#128521</td>
					<td class="emoji" onclick="insert_emoji(${notification_id}, '&#128525');">&#128525</td>
					<td class="emoji" onclick="insert_emoji(${notification_id}, '&#128526');">&#128526</td>
					<td class="emoji" onclick="insert_emoji(${notification_id}, '&#128533');">&#128533</td>
					<td class="emoji" onclick="insert_emoji(${notification_id}, '&#127775');">&#127775</td>
					<td class="emoji" onclick="insert_emoji(${notification_id}, '&#127774');">&#127774</td>
					</tr><tr>
					<td class="emoji" onclick="insert_emoji(${notification_id}, '&#127771');">&#127771</td>
					<td class="emoji" onclick="insert_emoji(${notification_id}, '&#127794');">&#127794</td>
					<td class="emoji" onclick="insert_emoji(${notification_id}, '&#127796');">&#127796</td>
					<td class="emoji" onclick="insert_emoji(${notification_id}, '&#127797');">&#127797</td>
					<td class="emoji" onclick="insert_emoji(${notification_id}, '&#127799');">&#127799</td>
					<td class="emoji" onclick="insert_emoji(${notification_id}, '&#127801');">&#127801</td>
					<td class="emoji" onclick="insert_emoji(${notification_id}, '&#127803');">&#127803</td>
					<td class="emoji" onclick="insert_emoji(${notification_id}, '&#127812');">&#127812</td>
					</tr><tr>
					<td class="emoji" onclick="insert_emoji(${notification_id}, '&#127817');">&#127817</td>
					<td class="emoji" onclick="insert_emoji(${notification_id}, '&#127818');">&#127818</td>
					<td class="emoji" onclick="insert_emoji(${notification_id}, '&#128004');">&#128004</td>
					<td class="emoji" onclick="insert_emoji(${notification_id}, '&#128007');">&#128007</td>
					<td class="emoji" onclick="insert_emoji(${notification_id}, '&#128010');">&#128010</td>
					<td class="emoji" onclick="insert_emoji(${notification_id}, '&#128011');">&#128011</td>
					<td class="emoji" onclick="insert_emoji(${notification_id}, '&#128029');">&#128029</td>
					<td class="emoji" onclick="insert_emoji(${notification_id}, '&#128030');">&#128030</td>
				</tr></table>`;

	if (div.innerHTML == '') {

		div.innerHTML = emojis;

	}

	if (div.hidden) {

		div.removeAttribute('hidden');

	} else {

		div.hidden = true;

	}

}
