/**
 * @package Tabaoca.Administrator
 * @subpackage com_gabble
 * @copyright (C) 2023 Jonatas C. Ferreira
 * @license GNU/AGPL v3 (see licence.txt)
 */

var n_users = 0,
	n_users_on = 0,
	n_feeds = 0,
	n_messages = 0,
	n_messages_gpt = 0;

var uri_base;
var tk;

function setup_admin () {

	uri_base = document.getElementById('uri_base').value;
	tk = document.getElementById('token').value;

	run_admin();

}

function run_admin () {

	var myForm = new FormData();
	var xhr = new XMLHttpRequest(); 
	var url = uri_base + 'index.php?option=com_gabble&view=gabble&task=gabble.run&format=json&' + tk + '=1';

	myForm.append('n_users', n_users);
	myForm.append('n_users_on', n_users_on);
	myForm.append('n_feeds', n_feeds);
	myForm.append('n_messages', n_messages);
	myForm.append('n_messages_gpt', n_messages_gpt);

	xhr.open("POST", url, true);

	xhr.onreadystatechange = function () {

								if (this.readyState == 4 && this.status == 200) {

									Jxhr = JSON.parse(xhr.response);

									if (Jxhr.data !== null) {

										if (Jxhr.data.users_on !== null) {

											document.getElementById('users_on').innerHTML = Jxhr.data.users_on;
											n_users_on = Jxhr.data.users_on;

										} else {

											document.getElementById('users_on').innerHTML = n_users_on;

										}

										if (Jxhr.data.users !== null) {

											document.getElementById('users').innerHTML = ' / ' + Jxhr.data.users;
											n_users = Jxhr.data.users;

										}

										if (Jxhr.data.feeds !== null) {

											document.getElementById('feeds').innerHTML = Jxhr.data.feeds;
											n_feeds = Jxhr.data.feeds;

										}

										if (Jxhr.data.messages !== null) {

											document.getElementById('messages').innerHTML = Jxhr.data.messages;
											n_messages = Jxhr.data.messages;

										}

										if (Jxhr.data.messages_gpt !== null) {

											document.getElementById('messages_gpt').innerHTML = Jxhr.data.messages_gpt;
											n_messages_gpt = Jxhr.data.messages_gpt;

										}

										setTimeout(function () { run_admin();}, 0);

									} else {

										alert(Joomla.JText._('COM_GABBLE_TIMEOUT'));
										location.reload();

									}

								}

							}

	xhr.send(myForm);

}
