<?php
/**
 * @package Tabaoca.Administrator
 * @subpackage com_gabble
 * @copyright (C) 2023 Jonatas C. Ferreira
 * @license GNU/AGPL v3 (see licence.txt)
 */

\defined('_JEXEC') or die;

use Joomla\CMS\Factory;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Uri\Uri;
use Joomla\CMS\Component\ComponentHelper;

$app = Factory::getApplication();
$document = Factory::getDocument();
$session = $app->getSession();
$config = ComponentHelper::getParams('com_gabble');

$cb_integration = $config->get('cb_integration');

if ($cb_integration && !ComponentHelper::isEnabled('com_comprofiler')) {

	$app->enqueueMessage(Text::_('COM_GABBLE_CB_INTEGRATION_WARNING'), 'warning');

}

$wa = $document->getWebAssetManager();
$wa->useScript('keepalive');

?>

<script language="JavaScript">

function addLoadEvent(func) {
	var oldonload = window.onload;
	if (typeof window.onload != 'function') {
			window.onload = func;
	} 
	else {
			window.onload = function() {
					if (oldonload) {
							oldonload();
					}
					func();
			}
		}
}

addLoadEvent(function(){setup_admin();});

</script>

<div class="container">

	<div id="data_gabble" class="row">

		<div class="col-md-4">

			<div class="row">

				<div class="box_data box_users">
					<span class="title_data"><i class="icon-users"></i><b> <?php echo Text::_('COM_GABBLE_USERS_ON');?></b></span>
					<div class="field_data">
						<span id="users_on"></span><span id="users"></span>
					</div>
				</div>

				<div class="box_data box_chats">
					<span class="title_data"><i class="icon-comments-2"></i><b> <?php echo Text::_('COM_GABBLE_CHATS');?></b></span>
					<div class="field_data">
						<span id="feeds"></span>
					</div>
				</div>

				<div class="box_data box_msgs">
					<span class="title_data"><i class="icon-comments"></i><b> <?php echo Text::_('COM_GABBLE_MESSAGES');?></b></span>
					<div class="field_data">
						<span id="messages"></span>
					</div>
				</div>

				<div class="box_data box_openai">
					<span class="title_data">
						<img src="<?php echo Uri::root(); ?>media/com_gabble/images/logo_openai.png" class="openai_logo_sm" alt="OpenAI GPT">
						<b><?php echo Text::_('COM_GABBLE_MESSAGES_GPT');?></b>
					</span>
					<div class="field_data">
						<span id="messages_gpt">0</span>
					</div>
				</div>

			</div>

		</div>

		<div class="col-md-4">

		</div>

	</div>

	<input type="hidden" id="uri_base" value="<?php echo Uri::base(); ?>">
	<input type="hidden" id="token" value="<?php echo $session->getFormToken(); ?>">

</div>

<p style="text-align:right;" ><?php echo Text::_('COM_GABBLE_POWERED');?> <a href="https://tabaoca.org">Tabaoca</a></p>
