<?php
/**
 * @package Tabaoca.Component.Gabble.Administrator
 * @subpackage com_gabble
 * @copyright (C) 2023 Jonatas C. Ferreira
 * @license GNU/AGPL v3 (see licence.txt)
 */

namespace Tabaoca\Component\Gabble\Administrator\View\Gabble;

\defined('_JEXEC') or die;

use Joomla\CMS\MVC\View\HtmlView as BaseHtmlView;
use Joomla\CMS\Factory;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Toolbar\ToolbarHelper;
use Joomla\CMS\Helper\ContentHelper;
use Joomla\CMS\Session\Session;
use Joomla\CMS\Uri\Uri;

class HtmlView extends BaseHtmlView {

	/**
	 * Display the Gabble Chat view
	 *
	 * @param   string  $tpl  The name of the template file to parse; automatically searches through the template paths.
	 *
	 * @return  void
	 */
	public function display($tpl = null) {

		$this->canDo = ContentHelper::getActions('com_gabble');

		// Set the toolbar
		$this->addToolBar();

		// Set the document
		$this->setDocument(null);

		// Display the template
		parent::display($tpl);

	}

	/**
	 * Add the page title and toolbar.
	 *
	 * @return  void
	 */
	protected function addToolBar() {

		ToolBarHelper::title(Text::_('COM_GABBLE_DASHBOARD'), 'gabble');

		if ($this->canDo->get('core.admin')) {

			ToolBarHelper::divider();
			ToolBarHelper::preferences('com_gabble');

		}

	}

	/**
	 * Method to set up the document properties
	 *
	 * @return void
	 */
	public function setDocument($doc): void {

		$document = Factory::getDocument();
		$document->setTitle(Text::_('COM_GABBLE_ADMINISTRATION'));

		$document->addScript(Uri::root() . 'media/com_gabble/js/gabble_admin.js');
		$document->addStyleSheet(Uri::root() . 'media/com_gabble/css/gabble_admin.css');
		Text::script('COM_GABBLE_TIMEOUT');

	}

}
