<?php
/**
 * @package Tabaoca.Component.Gabble.Administrator
 * @subpackage com_gabble
 * @copyright (C) 2023 Jonatas C. Ferreira
 * @license GNU/AGPL v3 (see licence.txt)
 */

namespace Tabaoca\Component\Gabble\Administrator\Model;

\defined('_JEXEC') or die;

use stdClass;
use Joomla\CMS\MVC\Model\BaseModel;
use Joomla\CMS\Factory;

/**
 * Model of Gabble Chat System component
 *
 * @package     Tabaoca.Component.Gabble.Administrator
 * @subpackage  com_gabble
 * @since       1.0.0
 */
class GabbleModel extends BaseModel {

	/**
	* Method to verify changed data on database.
	* 
	* @return  object  Response Data to XHR call.
	* @since   1.0.0
	*/
	public function run ($n_users_on, $n_users, $n_feeds, $n_messages, $n_messages_gpt) { 

		$trigger = true;

		$data = new stdClass();
		$data->users_on = null;
		$data->users = null;
		$data->feeds = null;
		$data->messages = null;
		$data->messages_gpt = null;

		do { 

			set_time_limit(20);

			$result = $this->data_gabble();

			if ($result->users_on != $n_users_on) {

				$data->users_on = $result->users_on;
				$trigger = false;

			}

			if ($result->users != $n_users) {

				$data->users = $result->users;
				$trigger = false;

			}

			if ($result->feeds != $n_feeds) {

				$data->feeds = $result->feeds;
				$trigger = false;

			}

			if ($result->messages != $n_messages) {

				$data->messages = $result->messages;
				$trigger = false;

			}

			if ($result->messages_gpt != $n_messages_gpt) {

				$data->messages_gpt = $result->messages_gpt;
				$trigger = false;

			}

			usleep(40);

		} while ($trigger);

		return $data;

	}

	/**
	* Method to verify number of online users, chats and messages.
	* 
	* @return  object  Response Data to XHR call.
	* @since   1.0.0
	*/
	public function data_gabble () {

		$data = new stdClass();

		$db = Factory::getDbo();
		$query_a = $db->getQuery(true);

		$query_a->select('id, name, username');
		$query_a->from($db->quoteName('#__users'));

		$db->setQuery($query_a);
		$db->execute();
		$data->users = $db->getNumRows();

		$query_b = $db->getQuery(true);

		$query_b->select($db->quoteName(array('userid','username')));
		$query_b->from($db->quoteName('#__session'));
		$query_b->where('guest = 0 AND client_id = 0');
		
		$db->setQuery($query_b);
		$db->execute();
		$data->users_on = $db->getNumRows();

		$query_c = $db->getQuery(true);

		$query_c->select($db->quoteName(array('id')));
		$query_c->from($db->quoteName('#__gabble_feed'));

		$db->setQuery($query_c);
		$db->execute();
		$data->feeds = $db->getNumRows();

		$query_d = $db->getQuery(true);

		$query_d->select($db->quoteName(array('id')));
		$query_d->from($db->quoteName('#__gabble_message'));
		$query_d->where('user_id != 0');

		$db->setQuery($query_d);
		$db->execute();
		$data->messages = $db->getNumRows();

		$query_e = $db->getQuery(true);

		$query_e->select($db->quoteName(array('id')));
		$query_e->from($db->quoteName('#__gabble_message'));
		$query_e->where('user_id = 0');

		$db->setQuery($query_e);
		$db->execute();
		$data->messages_gpt = $db->getNumRows();

		return $data;

	}

}
