<?php
/**
 * @package Tabaoca.Component.Gabble.Administrator
 * @subpackage com_gabble
 * @copyright (C) 2023 Jonatas C. Ferreira
 * @license GNU/AGPL v3 (see licence.txt)
 */

namespace Tabaoca\Component\Gabble\Administrator\Controller;

\defined('_JEXEC') or die;

use Joomla\CMS\MVC\Controller\BaseController;
use Joomla\CMS\Factory;
use Joomla\CMS\Session\Session;
use Joomla\CMS\Response\JsonResponse;
use Joomla\CMS\Language\Text;

/**
 * Controller of Gabble Chat System component
 *
 * @package     Tabaoca.Component.Gabble.Administrator
 * @subpackage  com_gabble
 * @since       1.0.0
 */
class GabbleController extends BaseController {

	/**
	* Method to start the loop to refresh data.
	* 
	* @return  object  Response JSON encoded object to XHR call.
	* @since   1.0.0
	*/
	public function run () {

		try {

			if (!Session::checkToken('get')) {

				echo new JsonResponse(null, Text::_('JINVALID_TOKEN'), true);

			} else {

				$input = Factory::getApplication()->input;

				$n_users_on = $input->get('n_users_on', 0, 'INT');
				$n_users = $input->get('n_users', 0, 'INT');
				$n_feeds = $input->get('n_feeds', 0, 'INT');
				$n_messages = $input->get('n_messages', 0, 'INT');
				$n_messages_gpt = $input->get('n_messages_gpt', 0, 'INT');

				$model = $this->getModel();

				$record = $model->run($n_users_on, $n_users, $n_feeds, $n_messages, $n_messages_gpt);

				echo new JsonResponse($record);

			}

		} catch (Exception $e) {

			echo new JsonResponse($e);

		}

	}

}
