DROP TABLE IF EXISTS `#__gabble_feed`;
DROP TABLE IF EXISTS `#__gabble_message`;
DROP TABLE IF EXISTS `#__gabble_notification`;

CREATE TABLE IF NOT EXISTS `#__gabble_feed`(
	`id` INT(11) NOT NULL AUTO_INCREMENT,
	`users_ids` LONGTEXT,
	`type` tinyint NOT NULL DEFAULT 0,
	`params` LONGTEXT,
	PRIMARY KEY(`id`)
	)
	ENGINE=InnoDB 
	DEFAULT CHARSET=utf8mb4 
	DEFAULT COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `#__gabble_message`(
	`id` INT(11) NOT NULL AUTO_INCREMENT,
	`user_id` INT(11) NOT NULL,
	`feed_id` INT(11) NOT NULL,
	`message` LONGTEXT NOT NULL,
	`sended` DATETIME NOT NULL,
	`react` LONGTEXT,
	`answer` INT(11) NOT NULL,
	`files` LONGTEXT,
	`params` LONGTEXT,
	PRIMARY KEY(`id`)
	)
	ENGINE=InnoDB 
	DEFAULT CHARSET=utf8mb4 
	DEFAULT COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `#__gabble_notification`(
	`id` INT(11) NOT NULL AUTO_INCREMENT,
	`feed_id` INT(11) NOT NULL,
	`user_id` INT(11) NOT NULL,
	`read_id` INT(11) NOT NULL,
	`active` TINYINT(1) NOT NULL DEFAULT 0,
	`w_open` TINYINT(1) NOT NULL DEFAULT 0,
	`w_index` TINYINT(2) NOT NULL DEFAULT 0,
	`date_in` DATETIME NOT NULL,
	`date_out` DATETIME NOT NULL,
	`params` LONGTEXT,
	PRIMARY KEY(`id`)
	)
	ENGINE=InnoDB 
	DEFAULT CHARSET=utf8mb4 
	DEFAULT COLLATE=utf8mb4_unicode_ci;
