<?php
/**
 * @package Tabaoca.Component.Cotton.Site
 * @subpackage com_cotton
 * @copyright (C) 2024 Jonatas C. Ferreira
 * @license GNU/AGPL v3 https://www.gnu.org/licenses/agpl-3.0.html
 */

\defined('_JEXEC') or die;

use Joomla\CMS\Factory;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Uri\Uri;

$currentuser = Factory::getApplication()->getIdentity();
$app = Factory::getApplication();
$session = $app->getSession();

$wa = Factory::getApplication()->getDocument()->getWebAssetManager();
$wa->useScript('keepalive');

$wa->getRegistry()->addExtensionRegistryFile('plg_editors_codemirror');
$wa->useStyle('plg_editors_codemirror')
    ->useScript('webcomponent.editor-codemirror');

if (!$currentuser->get("id")) {

	$app->enqueueMessage(Text::_('JERROR_ALERTNOAUTHOR'), 'error');
	$app->setHeader('status', 403, true);

	return;

}

?>

<script language="JavaScript">

function cotton_addLoadEvent(func) {
	
	let oldonload = window.onload;
	
	if (typeof window.onload != 'function') {
			window.onload = func;
	
	} else {
		window.onload = function() { if (oldonload) { oldonload(); }
									func(); }
									
	}

}

cotton_addLoadEvent(function(){setup_cotton();});

</script>

<main id="cotton_main" class="content">
</main>

<input type="hidden" id="uri_root_cotton" value="<?php echo Uri::root(); ?>">
<input type="hidden" id="token_cotton" value="<?php echo $session->getFormToken(); ?>">

<p style="text-align: right; font-size: smaller;" ><?php echo Text::_('COM_COTTON_POWERED');?> <a href="https://tabaoca.org">Tabaoca</a></p>