<?php
/**
 * @package Tabaoca.Component.Cotton.Site
 * @subpackage com_cotton
 * @copyright (C) 2024 Jonatas C. Ferreira
 * @license GNU/AGPL v3 https://www.gnu.org/licenses/agpl-3.0.html
 */

namespace Tabaoca\Component\Cotton\Site\View\Cotton;

\defined('_JEXEC') or die;

use Joomla\CMS\MVC\View\HtmlView as BaseHtmlView;
use Joomla\CMS\Factory;
use Joomla\CMS\Language\Text;

class HtmlView extends BaseHtmlView {
	
	/**
	 * Display the Cotton Cloud site view.
	 *
	 * @param   string  $tpl  The name of the template file to parse; automatically searches through the template paths.
	 *
	 * @return  void
	 */
	public function display($tpl = null) {

		$this->setDocument(null);

		//Display the site view
		parent::display($tpl);

	}
	
	/**
	 * Setup the Cotton Cloud site view.
	 *
	 * @param   string  $doc  The name of the template file to parse; automatically searches through the template paths.
	 *
	 * @return  string  Setup HTML inserts of Style Sheet, Script files and setup language variables in Javascript.
	 */
	public function setDocument($doc): void {

		$document = Factory::getDocument();
		$document->setTitle(Text::_('COM_COTTON'));
		$document->addScript('media/com_cotton/js/cotton_com.js');
		$document->addStyleSheet('media/com_cotton/css/cotton.css');

		Text::script('COM_COTTON_ARCHIVE_MANAGER');
		Text::script('COM_COTTON_ARCHIVE');
		Text::script('COM_COTTON_VIEW_INFO');
		Text::script('COM_COTTON_TOGGLE_VIEW');
		Text::script('COM_COTTON_CREATE_FOLDER');
		Text::script('COM_COTTON_CREATE_FILE');
		Text::script('COM_COTTON_UPLOAD_FILE');
		Text::script('COM_COTTON_UPLOAD_FILES');
		Text::script('COM_COTTON_CREATE');
		Text::script('COM_COTTON_UPDATE');
		Text::script('COM_COTTON_UPLOAD');
		Text::script('COM_COTTON_UPLOADING');
		Text::script('COM_COTTON_UPLOAD_NOFILE');
		Text::script('COM_COTTON_CREATEFOLDER_ERROR');
		Text::script('COM_COTTON_FOLDER_OPTIONS');
		Text::script('COM_COTTON_FOLDER_OPTIONS_ERROR');
		Text::script('COM_COTTON_FOLDER_NAME');
		Text::script('COM_COTTON_FOLDERNAME_EXISTS');
		Text::script('COM_COTTON_FOLDERNAME_INVALID');
		Text::script('COM_COTTON_FOLDERNAME_EMPTY');
		Text::script('COM_COTTON_CREATEFILE_ERROR');
		Text::script('COM_COTTON_FILE_OPTIONS');
		Text::script('COM_COTTON_FILE_NAME');
		Text::script('COM_COTTON_FILENAME_EXISTS');
		Text::script('COM_COTTON_FILENAME_INVALID');
		Text::script('COM_COTTON_FILENAME_EMPTY');
		Text::script('COM_COTTON_CANCEL');
		Text::script('COM_COTTON_CLOSE');
		Text::script('COM_COTTON_DONE');
		Text::script('COM_COTTON_CLEAR_TRASH');
		Text::script('COM_COTTON_OPTIONS');
		Text::script('COM_COTTON_DELETE');
		Text::script('COM_COTTON_DELETE_FOLDER');
		Text::script('COM_COTTON_DELETE_FILE');
		Text::script('COM_COTTON_DELETE_FOLDER_CONFIRM');
		Text::script('COM_COTTON_DELETE_FILE_CONFIRM');
		Text::script('COM_COTTON_CLEAR');
		Text::script('COM_COTTON_COPY_LINK');
		Text::script('COM_COTTON_DOWNLOAD');
		Text::script('COM_COTTON_TRASH');
		Text::script('COM_COTTON_TRASH_CLEAR');
		Text::script('COM_COTTON_TRASH_CLEAR_ALL');
		Text::script('COM_COTTON_RECOVER');
		Text::script('COM_COTTON_RECOVER_ITEM');
		Text::script('COM_COTTON_RECOVER_SELECT');
		Text::script('COM_COTTON_RECOVER_NOFOLDER');
		Text::script('COM_COTTON_SPECIFIC_USERS_INFO');
		Text::script('COM_COTTON_SPECIFIC_USERS');
		Text::script('COM_COTTON_REGISTERED_USERS');
		Text::script('COM_COTTON_ALL_USERS');
		Text::script('COM_COTTON_FOLDERS');
		Text::script('COM_COTTON_FILES');
		Text::script('COM_COTTON_OPEN_FOLDER');
		Text::script('COM_COTTON_OPEN_FILE');
		Text::script('COM_COTTON_NAME');
		Text::script('COM_COTTON_DESCRIPTION');
		Text::script('COM_COTTON_SHARED_LINK');
		Text::script('COM_COTTON_SIZE');
		Text::script('COM_COTTON_MODIFIED');
		Text::script('COM_COTTON_ITEMS');
		Text::script('COM_COTTON_NO_ITEM');
		Text::script('COM_COTTON_NO');
		Text::script('COM_COTTON_NO_APP');
		Text::script('COM_COTTON_SAVE');
		Text::script('COM_COTTON_OK');
		Text::script('COM_COTTON_ERROR');
		Text::script('COM_COTTON_ERROR_MAX_FILESIZE');
		
		Text::script('COM_COTTON_TIMEOUT');

	}

}
