/**
 * @package Tabaoca.Site
 * @subpackage com_cotton
 * @copyright (C) 2024 Jonatas C. Ferreira
 * @license GNU/AGPL v3 https://www.gnu.org/licenses/agpl-3.0.html
 */

// class CottonJS {}

const max_filesize_db = 4294967295;

var doc = document,
	uri_root_cotton,
	tk_cotton,
	active_folder_id = 0,
	active_tab_id = 0,
	folder_selected = null,
	view_items_type = 0,
	download_file_name = '',
	files_upload = [],
	file_upload_index = null,
	status_list = [],
	cotton_config = new Object(),
	cotton_data = new Object(),
	active_item = new Object();
	
	active_item.id = 0;
	active_item.type = '';

function setup_cotton () {

	uri_root_cotton = doc.getElementById('uri_root_cotton').value,
	tk_cotton = doc.getElementById('token_cotton').value;

	data_cotton('start');

}

function data_cotton (command, arguments) {

	let myForm = new FormData(),
		xhr = new XMLHttpRequest(),
		url = uri_root_cotton + 'index.php?option=com_cotton&view=cotton&task=cotton.'+ command +'&format=json';

	myForm.append(tk_cotton, 1);
	myForm.append('command', command);

	switch (command) {

		case 'folder_load':
			
			myForm.append('folder_id', arguments.folder_id);
		
			break;
		
		case 'folder_create':
			
			myForm.append('parent_id', arguments.parent_id);
			myForm.append('folder_name', arguments.folder_name);
			myForm.append('folder_description', arguments.folder_description);
		
			break;

		case 'folder_update':

			myForm.append('folder_id', arguments.folder_id);
			myForm.append('folder_name', arguments.folder_name);
			myForm.append('folder_description', arguments.folder_description);

			break;

		case 'file_create':
			
			myForm.append('folder_id', arguments.folder_id);
			myForm.append('file', arguments.file, arguments.file_name);
			myForm.append('file_description', arguments.file_description);
		
			break;

		case 'file_upload':

			myForm.append('folder_id', arguments.folder_id);
			myForm.append('file', arguments.file, arguments.file.name);
			myForm.append('index', arguments.index);

			break;

		case 'download':

			myForm.append('file_id', arguments.file_id);

			break;

		case 'file_update':

			myForm.append('file_id', arguments.file_id);
			myForm.append('file_name', arguments.file_name);
			myForm.append('file_description', arguments.file_description);
			myForm.append('file_open_link', arguments.file_open_link);
			myForm.append('file_allowed_users', arguments.file_allowed_users);

			break;

		case 'file_save':

			myForm.append('file_id', arguments.file_id);
			myForm.append('file', arguments.file, arguments.file.name);

			break;

		case 'item_delete':

			myForm.append('item_id', arguments.item_id);
			myForm.append('item_type', arguments.item_type);
			myForm.append('trash', arguments.trash);

			break;

		case 'item_recover':

			myForm.append('item_id', arguments.item_id);
			myForm.append('item_type', arguments.item_type);
			myForm.append('item_name', arguments.item_name);
			myForm.append('folder_id', arguments.folder_id);

			break;

		case 'open_editor':

			myForm.append('file_id', arguments.file_id);
			myForm.append('file_ext', arguments.file_ext);

			break;

	}

	xhr.open("POST", url, true);

	if (command == 'file_upload') {

		file_upload_index = arguments.index;
	
		xhr.upload.onprogress = function (e) { if (e.lengthComputable) {
									
											let percent_complete = (e.loaded / e.total) * 100;
											doc.getElementById('file_progress_' + file_upload_index).style.width = percent_complete + '%'; 

											}
										};

	}

	xhr.onreadystatechange = function () {

								if (this.readyState == 4 && this.status == 200) {

									if (command == 'download') {

										let file = new File([xhr.response], arguments.file_name);
										
										download(file);

									} else {

										Jxhr = JSON.parse(xhr.response);

										if (Jxhr.data !== null) {

											switch (command) {

												case 'start':

													cotton_data = Jxhr.data;

													cotton_config = Jxhr.data.config;
																										
													active_folder_id = cotton_data.active_folder_id;

													populate_main();
													populate_footer();
													populate_menu_actions('archive');
													doc.getElementById('cotton_folders').innerHTML = populate_list(cotton_data.list, 0, false);
													doc.getElementById('cotton_items').innerHTML = populate_items(cotton_data.folders, cotton_data.files);
													doc.getElementById('cotton_main').style.display = 'block';

													break;

												case 'folder_load':
													
													active_folder_id = Jxhr.data.active_folder_id;

													active_item.id = 0;
													active_item.type = '';
													
													if (cotton_data.n_list != Jxhr.data.n_list) {

														doc.getElementById('cotton_folders').innerHTML = populate_list(Jxhr.data.list, 0, false);
														folder_list_status();

													}
													
													cotton_data = Jxhr.data;
													populate_footer();
													
													if (active_tab_id) {

														populate_menu_actions('tab', doc.getElementById('cotton_tab_' + active_tab_id).dataset.editor);

													} else {

														populate_menu_actions('archive');

													}
												
													doc.getElementById('cotton_items').innerHTML = populate_items(cotton_data.folders, cotton_data.files);

													break;

												case 'folder_create':

													let args = new Object();
														args.folder_id = Jxhr.data.parent_id;
													
													data_cotton('folder_load', args);
																									
													screen_cancel();

													break;

												case 'folder_update':

													if (doc.getElementById('folder_item_name_' + Jxhr.data.id)) {

														let date_updated = Jxhr.data.date_updated.split(" ");

														cotton_data.folders[doc.getElementById('item_folder_' + Jxhr.data.id).dataset.index].name = Jxhr.data.name;
														doc.getElementById('item_folder_' + Jxhr.data.id).dataset.folder_name = Jxhr.data.name;
														doc.getElementById('item_folder_' + Jxhr.data.id).dataset.folder_date_updated = Jxhr.data.date_updated;
														doc.getElementById('item_folder_' + Jxhr.data.id).dataset.folder_description = Jxhr.data.description;
														doc.getElementById('item_folder_' + Jxhr.data.id).click();

														doc.getElementById('folder_item_name_' + Jxhr.data.id).innerHTML = mount_item_name(Jxhr.data.name, 'item');
														doc.getElementById('folder_item_name_' + Jxhr.data.id).title = Jxhr.data.name;
														doc.getElementById('folder_item_name_' + Jxhr.data.id).innerHTML = date_updated[0];
														doc.getElementById('folder_item_updated_' + Jxhr.data.id).title = date_updated[1];

													}

													if (doc.getElementById('info_view_name_' + Jxhr.data.id)) {

														doc.getElementById('info_view_name_' + Jxhr.data.id).innerHTML = Jxhr.data.name;
														doc.getElementById('info_view_description_' + Jxhr.data.id).innerHTML = Jxhr.data.description;

													}
												
													doc.getElementById('folder_list_name_' + Jxhr.data.id).innerText = Jxhr.data.name;
												
													screen_cancel();

													break;

												case 'file_create':

													if (Jxhr.data.success) {

														let args_load = new Object();
															args_load.folder_id = Jxhr.data.active_folder_id;

														data_cotton('folder_load', args_load);

														screen_cancel();

													} else {

														//error

													}

													break;

												case 'file_upload':

													if (!Jxhr.data.success) {

														doc.getElementById('form_progress_' + Jxhr.data.index).innerHTML = `<span title="${Jxhr.data.error}">Error</span>`;

													}

													if (Jxhr.data.index < files_upload.length - 1) {
														
														let args = new Object();

														args.folder_id = Jxhr.data.active_folder_id;
														args.file = files_upload[Jxhr.data.index + 1];
														args.index = Jxhr.data.index + 1;

														data_cotton('file_upload', args);

													} else {

														files_upload = [];
														
														doc.getElementById('form_file_uploading').style.display = 'none';
														doc.getElementById('form_file_upload_btn').style.display = 'block';

														let args_load = new Object();
															args_load.folder_id = Jxhr.data.active_folder_id;

														data_cotton('folder_load', args_load);

													}

													break;

												case 'file_save':

													if (Jxhr.data.success) {

														doc.getElementById('cotton_tab_editor_' + Jxhr.data.file_id).value = Jxhr.data.file_data;
														
														check_editor_text(Jxhr.data.file_id);

														let args_load = new Object();
															args_load.folder_id = active_folder_id;

														data_cotton('folder_load', args_load);

													} else {

														system_error('Saving File Error', Jxhr.data.error);

													}

													break;

												case 'file_update':

													if (doc.getElementById('file_name_' + Jxhr.data.id)) {
														
														let allowed_users = JSON.parse(Jxhr.data.allowed_users);
														let date_updated = Jxhr.data.date_updated.split(" ");

														cotton_data.files[doc.getElementById('item_file_' + Jxhr.data.id).dataset.index].name = Jxhr.data.name;
														doc.getElementById('item_file_' + Jxhr.data.id).dataset.file_name = Jxhr.data.name;
														doc.getElementById('item_file_' + Jxhr.data.id).dataset.file_date_updated = Jxhr.data.date_updated;
														doc.getElementById('item_file_' + Jxhr.data.id).dataset.file_description = Jxhr.data.description;
														doc.getElementById('item_file_' + Jxhr.data.id).dataset.file_open_link = Jxhr.data.open_link;
														doc.getElementById('item_file_' + Jxhr.data.id).dataset.file_allowed_users = Jxhr.data.allowed_users;
														doc.getElementById('item_file_' + Jxhr.data.id).click();
														
														switch (Jxhr.data.open_link) {

															case 0:

																if (allowed_users.length) {
																
																	doc.getElementById('shared_icon_' + Jxhr.data.id).innerHTML = `<span class="icon-user-circle cotton-icon-link" title="Specific Users"></span>`;
		
																} else {
																	
																	doc.getElementById('shared_icon_' + Jxhr.data.id).innerHTML = ``;

																}

																break;

															case 1:

																doc.getElementById('shared_icon_' + Jxhr.data.id).innerHTML = `<span class="icon-users cotton-icon-link" title="Registered Users"></span>`;

																break;

															case 2:

																doc.getElementById('shared_icon_' + Jxhr.data.id).innerHTML = `<span class="icon-link cotton-icon-link" title="All Users"></span>`;

																break;

														}

														

														doc.getElementById('file_name_' + Jxhr.data.id).innerHTML = mount_item_name(Jxhr.data.name, 'item');
														doc.getElementById('file_name_' + Jxhr.data.id).title = Jxhr.data.name;
														doc.getElementById('file_updated_' + Jxhr.data.id).innerHTML = date_updated[0];
														doc.getElementById('file_updated_' + Jxhr.data.id).title = date_updated[1];
														doc.getElementById('btn_file_download_' + Jxhr.data.id).onclick = function () {file_download(Jxhr.data.id), Jxhr.data.name};

													}

													if (doc.getElementById('cotton_tab_' + Jxhr.data.id)) {

														doc.getElementById('cotton_tab_name_' + Jxhr.data.id).innerHTML = mount_item_name(Jxhr.data.name, 'tab');
														doc.getElementById('cotton_tab_name_' + Jxhr.data.id).title = Jxhr.data.name;
														doc.getElementById('cotton_input').value = doc.getElementById('cotton_tab_' + active_tab_id).dataset.path + doc.getElementById('cotton_tab_' + active_tab_id).dataset.name;
														doc.getElementById('info_tab_file_name_' + Jxhr.data.id).innerHTML = Jxhr.data.name;
														doc.getElementById('info_tab_file_open_link_' + Jxhr.data.id).innerHTML = mount_open_link_info(Jxhr.data.open_link, JSON.parse(Jxhr.data.allowed_users));
														doc.getElementById('info_tab_file_description_' + Jxhr.data.id).innerHTML = Jxhr.data.description;

														doc.getElementById('cotton_tab_' + Jxhr.data.id).dataset.name = Jxhr.data.name;
														doc.getElementById('cotton_tab_' + Jxhr.data.id).dataset.date_updated = Jxhr.data.date_updated;
														doc.getElementById('cotton_tab_' + Jxhr.data.id).dataset.description = Jxhr.data.description;
														doc.getElementById('cotton_tab_' + Jxhr.data.id).dataset.open_link = Jxhr.data.open_link;
														doc.getElementById('cotton_tab_' + Jxhr.data.id).dataset.allowed_users = Jxhr.data.allowed_users;

													}

													if (doc.getElementById('info_view_file_name_' + Jxhr.data.id)) {

														doc.getElementById('info_view_file_name_' + Jxhr.data.id).innerHTML = Jxhr.data.name;
														doc.getElementById('info_view_file_open_link_' + Jxhr.data.id).innerHTML = mount_open_link_info(Jxhr.data.open_link, JSON.parse(Jxhr.data.allowed_users));
														doc.getElementById('info_view_file_description_' + Jxhr.data.id).innerHTML = Jxhr.data.description;

													}
												
													screen_cancel();

													break;

												case 'item_delete':

													if (Jxhr.data.success) {

														active_item.id = 0;
														active_item.type = '';
														
														if ((doc.getElementById('cotton_tab_' + Jxhr.data.item_id)) && (Jxhr.data.item_type == 'file')) {

															close_tab(Jxhr.data.item_id);
													
														}

														if (active_folder_id) {

															let args = new Object();
																args.folder_id = active_folder_id;

															data_cotton('folder_load', args);

														} else {

															data_cotton('load_trash');

														}
														
														screen_cancel();

													} else {

														//error

													}

													break;

												case 'item_recover':

													if (Jxhr.data.success) {

														folder_selected = null;

														active_item.id = 0;
														active_item.type = '';

														data_cotton('load_trash');

														screen_cancel();

													} else {

														//error

													}

													break;

												case 'load_trash':

													active_folder_id = 0;

													if (cotton_data.n_list != Jxhr.data.n_list) {

														doc.getElementById('cotton_folders').innerHTML = populate_list(Jxhr.data.list, 0, false);
														folder_list_status();

													}

													cotton_data.n_list = Jxhr.data.n_list;
													cotton_data.list = Jxhr.data.list;
													cotton_data.limits = Jxhr.data.limits;

													if (Jxhr.data.n_folders_trash || Jxhr.data.n_files_trash) {

														doc.getElementById('cotton_items').innerHTML = populate_items(Jxhr.data.folders_trash, Jxhr.data.files_trash);

													} else {

														doc.getElementById('cotton_items').innerHTML = '';

													}

													populate_menu_actions('trash');
													
													break;

												case 'clear_trash':

													if (Jxhr.data.success) {

														data_cotton('load_trash');

														screen_cancel();

													} else {

														//error

													}

													break;

												case 'open_editor':

													if (Jxhr.data.success) {
												
														let wrap = 'false';
														
														switch (Jxhr.data.file_ext) {

															case 'htm':
															case 'html':
															case 'xhtml':

																Jxhr.data.file_ext = 'html';
																break;

															case 'xml':

																break;

															case 'php':

																break;
															
															case 'js':
															case 'mjs':

																Jxhr.data.file_ext = 'javascript';
																break;

															case 'css':
															case 'less':
															case 'scss':
															case 'sass':

																Jxhr.data.file_ext = 'css';
																break;

															case 'json':
															case 'jsonld':

																Jxhr.data.file_ext = 'json';
																break;

															default:

																Jxhr.data.file_ext = 'markdown';
																wrap = 'true';
																break;

														}

														const editor = doc.createElement('joomla-editor-codemirror');

														let file_id = Jxhr.data.file_id;

														editor.id = 'joomla_tab_editor_' + Jxhr.data.file_id;
														editor.style = 'padding: 0px; border-right: 1px solid #000;';
														editor.setAttribute('options', '{"width":"100%","height":"400px","lineNumbers":true,"foldGutter":true,"lineWrapping":' + wrap + ',"activeLine":true,"highlightSelection":true,"mode":"' + Jxhr.data.file_ext + '","autoCloseBrackets":true,"keyMap":"","customExtensions":[]}');
														editor.onkeyup = function () {check_editor_text(file_id);}

														const text = doc.createElement('textarea');

														text.id = 'cotton_tab_editor_' + Jxhr.data.file_id;
														text.style.display = 'none';
														text.value = Jxhr.data.file_data;

														editor.appendChild(text);
														
														doc.getElementById('cotton_tab_content_' + Jxhr.data.file_id).appendChild(editor);
														
														doc.getElementById('cotton_tab_content_' + Jxhr.data.file_id).style.overflow = 'hidden';

													} else {

														doc.getElementById('cotton_tab_content_' + Jxhr.data.file_id).innerHTML = `<div class="cotton-alert-no-app">${Jxhr.data.error}</div>`;

													}

													break;

											}

										} else {

											alert(Joomla.JText._('COM_COTTON_TIMEOUT'));
											location.reload();

										}

									}

								}

							}

	xhr.send(myForm);

}

function check_editor_text (file_id) {

	if (doc.getElementById('joomla_tab_editor_' + file_id).jEditor.getValue() == doc.getElementById('cotton_tab_editor_' + file_id).value) {

		doc.getElementById('btn_tab_file_save_' + file_id).disabled = 'true';
		doc.getElementById('cotton_item_alt_' + file_id).style.display = 'none';

	} else {

		doc.getElementById('btn_tab_file_save_' + file_id).removeAttribute('disabled');
		doc.getElementById('cotton_item_alt_' + file_id).style.display = 'block';

	}


}

function tab_file_save (file_id){

	let args = new Object();

	args.file_id = file_id;
	
	if (doc.getElementById('joomla_tab_editor_' + file_id).jEditor.getValue() != doc.getElementById('cotton_tab_editor_' + file_id).value) {

		args.file = new File([doc.getElementById('joomla_tab_editor_' + file_id).jEditor.getValue()], doc.getElementById('cotton_tab_' + file_id).dataset.name);
		

		data_cotton('file_save', args);

	}

}

function populate_main () {

	let header = '';

	if (cotton_config.config_header == '1') {

		header = `<header id="cotton_header">
					<span class="icon-cloud cotton-icon"></span>
					<span id="cloud_title">${Joomla.JText._('COM_COTTON_ARCHIVE_MANAGER')}</span>
					<span class="cotton-btn-joomla" title="Joomla!®"><span class="icon-joomla cotton-icon-joomla"></span></span>
				  </header>`;

	}
	
	doc.getElementById('cotton_main').innerHTML = `<div id="cotton_screen"></div>

													${header}
													
													<nav id="cotton_path">
														<input id="cotton_input" type="text" disabled>
													</nav>

													<nav id="cotton_nav">
														<span id="cotton_menu_actions"></span>
														<span id="cotton_menu_view">
															<button id="view_info_item" type="button" class="btn btn-secondary btn-sm" onclick="show_item_view();"><span class="icon-eye" title="${Joomla.JText._('COM_COTTON_VIEW_INFO')}"></span></button>
															<button type="button" class="btn btn-secondary btn-sm" onclick="change_items_view();"><span id="view_type_items" class="icon-grid" title="${Joomla.JText._('COM_COTTON_TOGGLE_VIEW')}"></span></button>
														</span>
													</nav>

													<nav id="cotton_tabs">
														<ul id="cotton_tabs_list" class="nav">
															<li id="cotton_tab_0" class="cotton-tab-item-active" onclick="switch_tab(0);" data-id="0">
																<span class="icon-database cotton-tab-icon cotton-icon-archive-tab"></span>
																<strong class="cotton-tab-name">${Joomla.JText._('COM_COTTON_ARCHIVE')}</strong>
															</li>
														</ul>
													</nav>
													
													<nav id="cotton_tab_principal">
														<section id="cotton_tab_content_0" class="cotton-principal" style="display: flex;" data-id="0">
															<aside id="cotton_folders" class="col-md-2"></aside>
															<section id="cotton_items" class="row col-md-10"></section>
															<aside id="cotton_item_view" class="col-md-3"></aside>
														</section>
													</nav>

													<footer id="cotton_footer">
														<span id="footer_a"></span>
														<span id="footer_b"></span>
													</footer>`;

}

function populate_menu_actions (menu_type, editor) {

	doc.getElementById('footer_a').innerHTML = '';
	
	switch (menu_type) {

		case 'archive':
			
			doc.getElementById('cotton_menu_actions').innerHTML = `<button type="button" class="btn btn-success btn-sm" onclick="form_folder_create();">
																		<span class="icon-add"></span>
																		<span>${Joomla.JText._('COM_COTTON_CREATE_FOLDER')}</span>
																	</button>
																	<button type="button" class="btn btn-success btn-sm" onclick="form_file_create();">
																		<span class="icon-add"></span>
																		<span>${Joomla.JText._('COM_COTTON_CREATE_FILE')}</span>
																	</button>
																   	<button type="button" class="btn btn-success btn-sm" onclick="form_file_upload();">
																   		<span class="icon-cloud-upload"></span>
																		<span>${Joomla.JText._('COM_COTTON_UPLOAD_FILE')}</span>
																	</button>`;
			break;
		
		case 'trash':
			
			let disabled = '',
				trash_space = mount_file_size(cotton_data.limits.trash_used_space);

			doc.getElementById('footer_a').innerHTML = `<span class="icon-trash"></span>
														<span>${trash_space} / </span>`;

			if (doc.getElementById('cotton_items').innerHTML == '') {

				disabled = 'disabled';

			}

			doc.getElementById('cotton_menu_actions').innerHTML = `<button type="button" class="btn btn-danger btn-sm" onclick="form_clear_trash();" ${disabled}>
																		<span class="icon-trash"></span>
																		<span>${Joomla.JText._('COM_COTTON_CLEAR_TRASH')}</span>
																   </button>`;
			break;

		case 'tab':
			
			let tab = doc.getElementById('cotton_tab_' + active_tab_id),
				btn_save = '';

			if (editor == 'true') {

				btn_save = `<button id="btn_tab_file_save_${active_tab_id}" type="button" class="btn btn-success btn-sm" onclick="tab_file_save(${active_tab_id});" disabled>
								<span class="icon-save"></span>
								<span>${Joomla.JText._('COM_COTTON_SAVE')}</span>
							</button>`;

			}
			
			doc.getElementById('cotton_menu_actions').innerHTML = `${btn_save}
																	<button id="btn_tab_file_options_${active_tab_id}" type="button" class="btn btn-primary btn-sm" onclick="form_file_options();">
																		<span class="icon-options"></span>
																		<span>${Joomla.JText._('COM_COTTON_OPTIONS')}</span>
																	</button>
																	<button id="btn_tab_file_delete_${active_tab_id}" type="button" class="btn btn-danger btn-sm" onclick="form_item_delete();">
																		<span class="icon-trash"></span>
																		<span>${Joomla.JText._('COM_COTTON_DELETE')}</span>
																	</button>
																	<button id="btn_tab_copy_link_${active_tab_id}" type="button" class="btn btn-secondary btn-sm" onclick="copy_link(${active_tab_id});">
																		<span class="icon-copy"></span>
																		<span>${Joomla.JText._('COM_COTTON_COPY_LINK')}</span>
																	</button>
																	<button id="btn_tab_file_download_${active_tab_id}" type="button" class="btn btn-success btn-sm" onclick="file_download(${active_tab_id}, '${tab.dataset.name}');">
																		<span class="icon-cloud-download"></span>
																		<span>${Joomla.JText._('COM_COTTON_DOWNLOAD')}</span>
																	</button>`;
			break;

	}

}

function populate_list (folder_list, parent_id, select_folder) {

	let html = '',
		html_trash = '',
		folder_name_class = '',
		select_id = '',
		icon_folder = '',
		click_trash = '';

	if (select_folder) {

		select_id = '_select';

	}

	if (!parent_id) {
		
		html += `<ul id="cotton_ul${select_id}_archive" class="cotton-folder-ul cotton-nested cotton-active">`;
		
		icon_folder = 'icon-database cotton-icon-archive';
		
		if (select_folder) {

			click_trash = `onclick="folder_select_click(0);"`;
			folder_name_class = 'cotton-folder-name';

		} else {

			click_trash = `onclick="folder_list_click_load(0);"`;
			folder_name_class = 'cotton-folder-name-active';

		}

		if (!select_folder) {
		
			html_trash = `<li id="folder${select_id}_0" class="" data-path="/Trash">
								<span
									id="folder${select_id}_name_0"
									class="cotton-folder-name"
									${click_trash}>
									<span class="icon-trash cotton-icon-trash"></span>
									<span>${Joomla.JText._('COM_COTTON_TRASH')}</span>
								</span>
							</li>`;

		}

	} else {

		html += `<ul id="folder_ul${select_id}_${parent_id}" class="cotton-folder-ul cotton-nested">`;
		folder_name_class = 'cotton-folder-name';
		icon_folder = 'icon-folder cotton-icon-folder';

	}

	for (let i = 0; i < folder_list.length; i++) {

		if (folder_list[i].parent_id == parent_id) {

			let click_children = '',
				icon_arrow = '',
				li_margin = '';

			if (folder_haschildren(folder_list, folder_list[i].id)) {

				icon_arrow = `<span id="arrow${select_id}_${folder_list[i].id}" class="icon-arrow-right-3 cotton-folder-arrow" onclick="folder_list_click_arrow(${folder_list[i].id}, ${select_folder});"></span>`;
				li_margin = 'cotton-folder-li';

				if (select_folder) {

					click_children = `onclick="folder_list_click(${folder_list[i].id}, ${select_folder}); folder_select_click(${folder_list[i].id});"`;
		
				} else {
		
					click_children = `onclick="folder_list_click(${folder_list[i].id}, ${select_folder}); folder_list_click_load(${folder_list[i].id});"`;
		
				}

			} else {

				if (select_folder) {

					click_children = `onclick="folder_select_click(${folder_list[i].id});"`;
		
				} else {
		
					click_children = `onclick="folder_list_click_load(${folder_list[i].id});"`;
		
				}

			}

			html += `<li id="folder${select_id}_${folder_list[i].id}"
						class="${li_margin}"
						data-parent_id="${folder_list[i].parent_id}"
						data-path="${folder_list[i].path}"
						data-index="${i}">
						${icon_arrow}
						<span
							id="folder${select_id}_name_${folder_list[i].id}"
							class="${folder_name_class}"
							${click_children}>
							<span class="${icon_folder}"></span>
							<span id="folder_list_name_${folder_list[i].id}">${folder_list[i].name}</span>
						</span>`;

			if (folder_haschildren(folder_list, folder_list[i].id)) {

				html += populate_list(folder_list, folder_list[i].id, select_folder);

			}

			html += `</li>`;

			if (!folder_list[i].parent_id) {

				doc.getElementById('cotton_input').value = folder_list[i].path;

			}

		}

	}

	html += html_trash + `</ul>`;

	return html;

}

function folder_list_status () {

	if (status_list.length) {

		if ((status_list.indexOf(active_folder_id) == -1) && (folder_haschildren(cotton_data.list, active_folder_id))) {

			if (active_folder_id) {

				status_list.push(active_folder_id);

			}

		}

		for (let i = 0; i < status_list.length; i++) {

			if (doc.getElementById('folder_name_' + status_list[i]).className == 'cotton-folder-name-active') {

				doc.getElementById('folder_name_' + status_list[i]).className = 'cotton-folder-name';

			}
			
			if (folder_haschildren(cotton_data.list, status_list[i])) {

				doc.getElementById(`folder_ul_${status_list[i]}`).className = 'cotton-folder-ul cotton-active';
				doc.getElementById(`arrow_${status_list[i]}`).className = 'icon-arrow-down-3 cotton-folder-arrow';
				doc.getElementById(`folder_${status_list[i]}`).className = 'cotton-folder-li-down';

			}

		}

		doc.getElementById('folder_name_' + active_folder_id).className = 'cotton-folder-name-active';

		doc.getElementById('cotton_input').value = doc.getElementById(`folder_${active_folder_id}`).dataset.path;

	}

}

function folder_haschildren (folder_list, folder_id) {

	for (let i = 0; i < folder_list.length; i++) {

		if (folder_list[i].parent_id == folder_id) {

			return true;

		}
		
	}

	return false;

}

function folder_list_click (folder_id, select_folder) {

	let select_id = '';
	
	if (select_folder) {

		select_id = '_select';

	}
	
	if (doc.getElementById(`folder_ul${select_id}_${folder_id}`).className == 'cotton-folder-ul cotton-nested') {
		
		doc.getElementById(`folder_ul${select_id}_${folder_id}`).className = 'cotton-folder-ul cotton-active';
		doc.getElementById(`arrow${select_id}_${folder_id}`).className = 'icon-arrow-down-3 cotton-folder-arrow';
		doc.getElementById(`folder${select_id}_${folder_id}`).className = 'cotton-folder-li-down';

		status_list.push(folder_id);

	} else if ((doc.getElementById(`folder_ul${select_id}_${folder_id}`).className == 'cotton-folder-ul cotton-active') && (active_folder_id == folder_id)) {
		
		doc.getElementById(`folder_ul${select_id}_${folder_id}`).className = 'cotton-folder-ul cotton-nested';
		doc.getElementById(`arrow${select_id}_${folder_id}`).className = 'icon-arrow-right-3 cotton-folder-arrow';
		doc.getElementById(`folder${select_id}_${folder_id}`).className = 'cotton-folder-li';

		if (status_list.indexOf(folder_id) != -1) {

			status_list.toSpliced(status_list.indexOf(folder_id), 1);

		}

	}

}

function folder_list_click_arrow (folder_id, select_folder) {

	let select_id = '';
	
	if (select_folder) {

		select_id = '_select';

	}
	
	if (doc.getElementById(`folder_ul${select_id}_${folder_id}`).className == 'cotton-folder-ul cotton-nested') {

		doc.getElementById(`folder_ul${select_id}_${folder_id}`).className = 'cotton-folder-ul cotton-active';
		doc.getElementById(`arrow${select_id}_${folder_id}`).className = 'icon-arrow-down-3 cotton-folder-arrow';
		doc.getElementById(`folder${select_id}_${folder_id}`).className = 'cotton-folder-li-down';

	} else if (doc.getElementById(`folder_ul${select_id}_${folder_id}`).className == 'cotton-folder-ul cotton-active') {

		doc.getElementById(`folder_ul${select_id}_${folder_id}`).className = 'cotton-folder-ul cotton-nested';
		doc.getElementById(`arrow${select_id}_${folder_id}`).className = 'icon-arrow-right-3 cotton-folder-arrow';
		doc.getElementById(`folder${select_id}_${folder_id}`).className = 'cotton-folder-li';

	}

}

function folder_list_click_load (folder_id) {

	doc.getElementById('folder_name_' + active_folder_id).className = 'cotton-folder-name';
	doc.getElementById('folder_name_' + folder_id).className = 'cotton-folder-name-active';

	doc.getElementById('cotton_input').value = doc.getElementById(`folder_${folder_id}`).dataset.path;

	active_item.id = 0;
	active_item.type = '';
	show_item_object('view');

	let args = new Object();
	args.folder_id = folder_id;

	if (!folder_id) {

		data_cotton('load_trash');

	} else if (folder_id != active_folder_id) {
	
		data_cotton('folder_load', args);

	}

}

function folder_select_click (folder_id) {

	if (folder_selected !== null) {
	
		doc.getElementById('folder_select_name_' + folder_selected).className = 'cotton-folder-name';

	}

	doc.getElementById('folder_select_name_' + folder_id).className = 'cotton-folder-name-active';

	folder_selected = folder_id;

}

function folder_click_open () {

	if (active_item.type == 'folder') {

		let parent_id = active_item.folder_parent_id;

		while (parent_id != 0) {

			doc.getElementById(`folder_ul_${parent_id}`).className = 'cotton-folder-ul cotton-active';
			doc.getElementById(`arrow_${parent_id}`).className = 'icon-arrow-down-3 cotton-folder-arrow';
			doc.getElementById(`folder_${parent_id}`).className = 'cotton-folder-li-down';

			parent_id = doc.getElementById(`folder_${parent_id}`).dataset.parent_id;

		}
		
		doc.getElementById('folder_name_' + active_item.id).click();

	}

}

function populate_items (folders, files) {

	let html = '',
		html_buttons = '';

	if (view_items_type) {
	
		if (folders !== null) {
		
			for (let i = 0; i < folders.length; i++) {

				let item_name = mount_item_name(folders[i].name, 'item'),
					dblclick = '';

				if (!active_folder_id) {

					html_buttons = `<div id="btn_folder_actions_${folders[i].id}" class="cotton-item-actions-none">
										<button id="btn_folder_recover_${folders[i].id}"
												type="button"
												class="btn btn-primary btn-sm cotton-btn-grid-actions"
												onclick="select_item(${folders[i].id}, 'folder'); form_item_recover(${folders[i].id}, 'folder', '${folders[i].name}'); event.stopPropagation();"
												title="${Joomla.JText._('COM_COTTON_RECOVER')}">
											<span class="icon-arrow-up-4"></span>
										</button>
									</div>`;

					

				} else {

					html_buttons = `<div id="btn_folder_actions_${folders[i].id}" class="cotton-item-actions-none">
										<button id="btn_folder_options_${folders[i].id}"
												type="button"
												class="btn btn-primary btn-sm cotton-btn-grid-actions"
												onclick="select_item(${folders[i].id}, 'folder'); form_folder_options(); event.stopPropagation();"
												title="${Joomla.JText._('COM_COTTON_OPTIONS')}">
											<span class="icon-options"></span>
										</button>
										<button id="btn_folder_delete_${folders[i].id}"
												type="button" class="btn btn-danger btn-sm cotton-btn-grid-actions"
												onclick="select_item(${folders[i].id}, 'folder'); form_item_delete(); event.stopPropagation();"
												title="${Joomla.JText._('COM_COTTON_DELETE')}">
											<span class="icon-trash"></span>
										</button>
									</div>`;

					dblclick = 'ondblclick="folder_click_open();"';

				}
				
				html += `<article id="item_folder_${folders[i].id}" name="list_item_id"
							class="cotton-item"
							data-id="${folders[i].id}"
							data-type="folder"
							data-index = "${i}"
							data-folder_owner_id="${folders[i].owner_id}"
							data-folder_name="${folders[i].name}"
							data-folder_description="${folders[i].description}"
							data-folder_date_created="${folders[i].date_created}"
							data-folder_date_updated="${folders[i].date_updated}"
							data-folder_featured="${folders[i].featured}"
							data-folder_parent_id="${folders[i].parent_id}"
							data-folder_allowed_users="${folders[i].allowed_users}"
							data-folder_open_link="${folders[i].open_link}"
							data-folder_trash="${folders[i].trash}"
							data-folder_params="${folders[i].params}"
							data-folder_n_folders="${folders[i].n_folders}"
							data-folder_n_files="${folders[i].n_files}"
							onclick="select_item(${folders[i].id}, 'folder');"
							${dblclick}
							onmouseover="show_btn_actions_over(${folders[i].id}, 'folder');"
							onmouseleave="show_btn_actions_leave(${folders[i].id}, 'folder');"
							style="position: relative;">
							<div>
								<span class="icon-folder cotton-item-icon cotton-icon-folder"></span>
							</div>
							<div>
								<span id="folder_item_name_${folders[i].id}" class="cotton-item-name" title="${folders[i].name}">${item_name}</span>
							</div>
							${html_buttons}
						</article>`;
				
			}

		}

		if (files !== null) {

			for (let i = 0; i < files.length; i++) {

				let item_name = mount_item_name(files[i].name, 'item'),
					icon_type = icon_file_type(files[i].name, files[i].mime_type) + ' cotton-item-icon',
					allowed_users = JSON.parse(files[i].allowed_users),
					icon_open_link = '',
					dblclick = '';

				switch (files[i].open_link) {

					case 0:
						
						if (allowed_users.length) {
							
							icon_open_link = `<span class="icon-user-circle cotton-icon-link" title="${Joomla.JText._('COM_COTTON_SPECIFIC_USERS')}"></span>`;
		
						} else {
							
							icon_open_link = '';

						}
						break;

					case 1:

						icon_open_link = `<span class="icon-users cotton-icon-link" title="${Joomla.JText._('COM_COTTON_REGISTERED_USERS')}"></span>`;
						break;

					case 2:

						icon_open_link = `<span class="icon-link cotton-icon-link" title="${Joomla.JText._('COM_COTTON_ALL_USERS')}"></span>`;
						break;

				}

				if (!active_folder_id) {

					html_buttons = `<div id="btn_file_actions_${files[i].id}" class="cotton-item-actions-none">
										<button id="btn_file_recover_${files[i].id}"
												type="button"
												class="btn btn-primary btn-sm cotton-btn-grid-actions"
												onclick="select_item(${files[i].id}, 'file'); form_item_recover(${files[i].id}, 'file', '${files[i].name}'); event.stopPropagation();"
												title="${Joomla.JText._('COM_COTTON_RECOVER')}">
											<span class="icon-arrow-up-4"></span>
										</button>
									</div>`;
					
				} else {

					html_buttons = `<div id="btn_file_actions_${files[i].id}" class="cotton-item-actions-none">
										<button id="btn_file_options_${files[i].id}"
												type="button"
												class="btn btn-primary btn-sm cotton-btn-grid-actions"
												onclick="select_item(${files[i].id}, 'file'); form_file_options(); event.stopPropagation();"
												title="${Joomla.JText._('COM_COTTON_OPTIONS')}">
											<span class="icon-options"></span>
										</button>
										<button id="btn_file_delete_${files[i].id}"
												type="button"
												class="btn btn-danger btn-sm cotton-btn-grid-actions"
												onclick="select_item(${files[i].id}, 'file'); form_item_delete(); event.stopPropagation();"
												title="${Joomla.JText._('COM_COTTON_DELETE')}">
											<span class="icon-trash"></span>
										</button>
										<button id="btn_copy_link_${files[i].id}"
												type="button"
												class="btn btn-secondary btn-sm cotton-btn-grid-actions"
												onclick="select_item(${files[i].id}, 'file'); copy_link(${files[i].id}); event.stopPropagation();"
												title="${Joomla.JText._('COM_COTTON_COPY_LINK')}">
											<span class="icon-copy"></span>
										</button>
										<button id="btn_file_download_${files[i].id}"
												type="button"
												class="btn btn-success btn-sm cotton-btn-grid-actions"
												onclick="select_item(${files[i].id}, 'file'); file_download(${files[i].id}, '${files[i].name}'); event.stopPropagation();"
												title="${Joomla.JText._('COM_COTTON_DOWNLOAD')}">
											<span class="icon-cloud-download"></span>
										</button>
									</div>`;

					dblclick = `ondblclick="show_item_object('tab'); create_tab();"`;

				}

				html += `<article id="item_file_${files[i].id}" name="list_item_id"
							class="cotton-item"
							data-id="${files[i].id}"
							data-type="file"
							data-index = "${i}"
							data-file_owner_id="${files[i].owner_id}"
							data-file_name="${files[i].name}"
							data-file_description="${files[i].description}"
							data-file_date_created="${files[i].date_created}"
							data-file_date_updated="${files[i].date_updated}"
							data-file_featured="${files[i].featured}"
							data-file_downloads="${files[i].downloads}"
							data-file_size="${files[i].size}"
							data-file_mime_type="${files[i].mime_type}"
							data-file_folder_id="${files[i].folder_id}"
							data-file_allowed_users="${files[i].allowed_users}"
							data-file_open_link="${files[i].open_link}"
							data-file_trash="${files[i].trash}"
							data-file_params="${files[i].params}"
							data-file_path="${files[i].path}"
							onclick="select_item(${files[i].id}, 'file');"
							${dblclick}
							onmouseover="show_btn_actions_over(${files[i].id}, 'file');"
							onmouseleave="show_btn_actions_leave(${files[i].id}, 'file');"
							style="position: relative;">
							<div>
								<span class="${icon_type}"></span>
								<span id="shared_icon_${files[i].id}">${icon_open_link}</span>
							</div>
							<div>
								<span id="file_name_${files[i].id}" class="cotton-item-name" title="${files[i].name}">${item_name}</span>
							</div>
							${html_buttons}
						</article>`;

			}

		}

	} else {

		html = `<header id="items_list" class="row cotton-item-title">
					<div class="col-md-8">
						<strong><span class="cotton-item-name">${Joomla.JText._('COM_COTTON_NAME')}</span></strong>
					</div>
					<div class="col-md-2">
						<strong><span class="cotton-item-name">${Joomla.JText._('COM_COTTON_SIZE')}</span></strong>
					</div>
					<div class="col-md-2">
						<strong><span class="cotton-item-name">${Joomla.JText._('COM_COTTON_MODIFIED')}</span></strong>
					</div>
				</header>`;

		if (folders !== null) {
		
			for (let i = 0; i < folders.length; i++) {

				let item_name = mount_item_name(folders[i].name, 'item'),
					n_items = folders[i].n_folders + folders[i].n_files,
					date_updated = folders[i].date_updated.split(" "),
					dblclick = '';

				if (!active_folder_id) {

					html_buttons = `<div id="btn_folder_actions_${folders[i].id}" class="cotton-item-actions-none">
										<button id="btn_folder_recover_${folders[i].id}"
												type="button"
												class="btn btn-primary btn-sm"
												onclick="select_item(${folders[i].id}, 'folder'); form_item_recover(${folders[i].id}, 'folder', '${folders[i].name}'); event.stopPropagation();"
												title="${Joomla.JText._('COM_COTTON_RECOVER')}">
											<span class="icon-arrow-up-4"></span>
										</button>
									</div>`;

				} else {

					html_buttons = `<div id="btn_folder_actions_${folders[i].id}" class="cotton-item-actions-none">
										<button id="btn_folder_options_${folders[i].id}"
												type="button"
												class="btn btn-primary btn-sm"
												onclick="select_item(${folders[i].id}, 'folder'); form_folder_options(); event.stopPropagation();"
												title="${Joomla.JText._('COM_COTTON_OPTIONS')}">
											<span class="icon-options"></span>
										</button>
										<button id="btn_folder_delete_${folders[i].id}"
												type="button"
												class="btn btn-danger btn-sm"
												onclick="select_item(${folders[i].id}, 'folder'); form_item_delete(); event.stopPropagation();"
												title="${Joomla.JText._('COM_COTTON_DELETE')}">
											<span class="icon-trash"></span>
										</button>
									</div>`;

					dblclick = 'ondblclick="folder_click_open();"';

				}

				html += `<article id="item_folder_${folders[i].id}" name="list_item_id"
							class="row cotton-item-list"
							data-id="${folders[i].id}"
							data-type="folder"
							data-index = "${i}"
							data-folder_owner_id="${folders[i].owner_id}"
							data-folder_name="${folders[i].name}"
							data-folder_description="${folders[i].description}"
							data-folder_date_created="${folders[i].date_created}"
							data-folder_date_updated="${folders[i].date_updated}"
							data-folder_featured="${folders[i].featured}"
							data-folder_parent_id="${folders[i].parent_id}"
							data-folder_allowed_users="${folders[i].allowed_users}"
							data-folder_open_link="${folders[i].open_link}"
							data-folder_trash="${folders[i].trash}"
							data-folder_params="${folders[i].params}"
							data-folder_n_folders="${folders[i].n_folders}"
							data-folder_n_files="${folders[i].n_files}"
							onclick="select_item(${folders[i].id}, 'folder');"
							${dblclick}
							onmouseover="show_btn_actions_over(${folders[i].id}, 'folder');"
							onmouseleave="show_btn_actions_leave(${folders[i].id}, 'folder');">

							<div class="col-md-8" style="position: relative;">
								<span class="icon-folder cotton-icon-folder"></span>
								<span id="folder_item_name_${folders[i].id}" class="cotton-item-name" title="${folders[i].name}">${item_name}</span>
								${html_buttons}
							</div>
							<div class="col-md-2">
								<span class="cotton-item-name">${n_items} ${Joomla.JText._('COM_COTTON_ITEMS')}</span>
							</div>
							<div class="col-md-2">
								<span id="folder_item_updated_${folders[i].id}" class="cotton-item-name" title="${date_updated[1]}">${date_updated[0]}</span>
							</div>

						</article>`;
				
			}

		}

		if (files !== null) {

			for (let i = 0; i < files.length; i++) {

				let item_name = mount_item_name(files[i].name, 'item'),
					file_size = mount_file_size(files[i].size),
					icon_type = icon_file_type(files[i].name, files[i].mime_type),
					date_updated = files[i].date_updated.split(" "),
					icon_open_link = '',
					allowed_users = JSON.parse(files[i].allowed_users),
					dblclick = '';

				switch (files[i].open_link) {

					case 0:
						
						if (allowed_users.length) {
								
							icon_open_link = `<span class="icon-user-circle cotton-icon-link" title="${Joomla.JText._('COM_COTTON_SPECIFIC_USERS')}"></span>`;
		
						} else {
						
							icon_open_link = '';
							
						}
						break;

					case 1:

						icon_open_link = `<span class="icon-users cotton-icon-link" title="${Joomla.JText._('COM_COTTON_REGISTERED_USERS')}"></span>`;
						break;

					case 2:

						icon_open_link = `<span class="icon-link cotton-icon-link" title="${Joomla.JText._('COM_COTTON_ALL_USERS')}"></span>`;
						break;

				}

				if (!active_folder_id) {

					html_buttons = `<div id="btn_file_actions_${files[i].id}" class="cotton-item-actions-none">
										<button id="btn_file_recover_${files[i].id}"
												type="button"
												class="btn btn-primary btn-sm"
												onclick="select_item(${files[i].id}, 'file'); form_item_recover(${files[i].id}, 'file', '${files[i].name}'); event.stopPropagation();"
												title="${Joomla.JText._('COM_COTTON_RECOVER')}">
											<span class="icon-arrow-up-4"></span>
										</button>
									</div>`;

				} else {

					html_buttons = `<div id="btn_file_actions_${files[i].id}" class="cotton-item-actions-none">
										<button id="btn_file_options_${files[i].id}"
												type="button"
												class="btn btn-primary btn-sm"
												onclick="select_item(${files[i].id}, 'file'); form_file_options(); event.stopPropagation();"
												title="${Joomla.JText._('COM_COTTON_OPTIONS')}">
											<span class="icon-options"></span>
										</button>
										<button id="btn_file_delete_${files[i].id}"
												type="button"
												class="btn btn-danger btn-sm"
												onclick="select_item(${files[i].id}, 'file'); form_item_delete(); event.stopPropagation();"
												title="${Joomla.JText._('COM_COTTON_DELETE')}">
											<span class="icon-trash"></span>
										</button>
										<button id="btn_copy_link_${files[i].id}"
												type="button"
												class="btn btn-secondary btn-sm"
												onclick="copy_link(${files[i].id}); event.stopPropagation();"
												title="${Joomla.JText._('COM_COTTON_COPY_LINK')}">
											<span class="icon-copy"></span>
										</button>
										<button id="btn_file_download_${files[i].id}"
												type="button"
												class="btn btn-success btn-sm"
												onclick="file_download(${files[i].id}, '${files[i].name}'); event.stopPropagation();"
												title="${Joomla.JText._('COM_COTTON_DOWNLOAD')}">
											<span class="icon-cloud-download"></span>
										</button>
									</div>`;

					dblclick = `ondblclick="show_item_object('tab'); create_tab();"`;

				}
				
				html += `<article id="item_file_${files[i].id}" name="list_item_id"
							class="row cotton-item-list"
							data-id="${files[i].id}"
							data-type="file"
							data-index = "${i}"
							data-file_owner_id="${files[i].owner_id}"
							data-file_name="${files[i].name}"
							data-file_description="${files[i].description}"
							data-file_date_created="${files[i].date_created}"
							data-file_date_updated="${files[i].date_updated}"
							data-file_featured="${files[i].featured}"
							data-file_downloads="${files[i].downloads}"
							data-file_size="${files[i].size}"
							data-file_mime_type="${files[i].mime_type}"
							data-file_folder_id="${files[i].folder_id}"
							data-file_allowed_users="${files[i].allowed_users}"
							data-file_open_link="${files[i].open_link}"
							data-file_trash="${files[i].trash}"
							data-file_params="${files[i].params}"
							data-file_path="${files[i].path}"
							onclick="select_item(${files[i].id}, 'file');"
							${dblclick}
							onmouseover="show_btn_actions_over(${files[i].id}, 'file');"
							onmouseleave="show_btn_actions_leave(${files[i].id}, 'file');">
							<div class="col-md-8" style="position: relative;">
								<span class="${icon_type}"></span>
								<span id="shared_icon_${files[i].id}">${icon_open_link}</span>
								<span id="file_name_${files[i].id}" class="cotton-item-name" title="${files[i].name}">${item_name}</span>
								${html_buttons}
							</div>
							<div class="col-md-2">
								<span class="cotton-item-name" title="${files[i].size}B">${file_size}</span>
							</div>
							<div class="col-md-2">
								<span id="file_updated_${files[i].id}" class="cotton-item-name" title="${date_updated[1]}">${date_updated[0]}</span>
							</div>
						</article>`;
				
			}

		}

	}

	return html;
	
}

function get_ext (file_name) {

	let file_ext = file_name.split('.');

	if (file_ext.length > 1) {

		return file_ext[file_ext.length -1];

	} else {

		return file_name;

	}

}

function get_type (file_ext) {

	if (cotton_config.text_formats.includes(file_ext)) {

		return 'text';

	}

	if (cotton_config.image_formats.includes(file_ext)) {

		return 'image';

	}

	if (cotton_config.video_formats.includes(file_ext)) {

		return 'video';

	}

	if (cotton_config.audio_formats.includes(file_ext)) {

		return 'audio';

	}

	return 'other';

}

function icon_file_type (file_name, mime_type) {

	let file_type = get_type(get_ext(file_name));

	mime_type = mime_type.split('/');
				
	switch (file_type) {

		case 'text':
			icon_type = 'icon-file';
			break;
		case 'image':
			icon_type = 'icon-image cotton-icon-file';
			break;
		case 'video':
			icon_type = 'icon-video cotton-icon-file';
			break;
		case 'audio':
			icon_type = 'icon-music cotton-icon-file';
			break;
		default:
			icon_type = 'icon-cube cotton-icon-app';

	}

	if (mime_type[0] == 'text') {

		icon_type = 'icon-file';

	}

	return icon_type;

}

function create_tab () {

	if (active_item.type == 'file') {

		let tab_id = active_item.id,
			tab_name = mount_item_name(active_item.file_name, 'tab'),
			icon_type = icon_file_type(active_item.file_name, active_item.file_mime_type) + ' cotton-tab-icon',
			mime_type = active_item.file_mime_type.split('/');
			
		let file_ext = get_ext(active_item.file_name);
		let open_editor = false;


		if (cotton_config.text_formats.includes(file_ext) || mime_type[0] == 'text') {

			open_editor = true;

		}

		if (!doc.getElementById('cotton_tab_' + tab_id)) {

			const tab = doc.createElement('li');

			tab.id = 'cotton_tab_' + tab_id;
			tab.className = 'cotton-tab-item';
			tab.title = active_item.file_name;

			tab.dataset.id = tab_id;
			tab.dataset.type = active_item.type;
			tab.dataset.owner_id = active_item.file_owner_id;
			tab.dataset.name = active_item.file_name;
			tab.dataset.description = active_item.file_description;
			tab.dataset.date_created = active_item.file_date_created;
			tab.dataset.date_updated = active_item.file_date_updated;
			tab.dataset.featured = active_item.file_featured;
			tab.dataset.downloads = active_item.file_downloads;
			tab.dataset.size = active_item.file_size;
			tab.dataset.mime_type = active_item.file_mime_type;
			tab.dataset.folder_id = active_item.file_folder_id;
			tab.dataset.allowed_users = active_item.file_allowed_users;
			tab.dataset.open_link = active_item.file_open_link;
			tab.dataset.trash = active_item.file_trash;
			tab.dataset.params = active_item.file_params;
			tab.dataset.path = active_item.file_path + '/';

			tab.onclick = function () { switch_tab(tab_id); }
			
			tab.innerHTML = `<span class="${icon_type}"></span>
							 <span id="cotton_tab_name_${tab_id}">${tab_name}</span>
							 <span class="icon-cancel" onclick="close_tab(${tab_id}); event.stopPropagation();"></span>
							 <span id="cotton_item_alt_${tab_id}" class="icon-circle cotton-item-alt"></span>`;

			const tab_principal= doc.createElement('section');
			
			tab_principal.id = 'cotton_tab_content_' + tab_id;
			tab_principal.className = 'row cotton-principal';
			tab_principal.style.display = 'none';
			tab_principal.dataset.id = tab_id;
			
			if (open_editor) {

				tab.dataset.editor = 'true';

				let args = new Object();

				args.file_id = tab_id;
				args.file_ext = file_ext;
				
				data_cotton('open_editor', args);

			} else {

				tab.dataset.editor = 'false';

				tab_principal.innerHTML = `<section id="cotton_tab_content_${tab_id}" class="col-md-8 cotton-border-r">
												${active_item.content}
											</section>
											<aside id="cotton_tab_info_${tab_id}" class="col-md-4 cotton-border-r">
													<div>${active_item.info}</div>
											</aside>`;
			
			}
			
			doc.getElementById('cotton_tabs_list').appendChild(tab);
			doc.getElementById('cotton_tab_principal').appendChild(tab_principal);

		}
			
		switch_tab(tab_id);

	}

}

function switch_tab (file_id) {

	if (active_tab_id != file_id) {

		doc.getElementById('cotton_tab_' + active_tab_id).className = 'cotton-tab-item';
		doc.getElementById('cotton_tab_content_' + active_tab_id).style.display = 'none';

		doc.getElementById('cotton_tab_' + file_id).className = 'cotton-tab-item-active';
		doc.getElementById('cotton_tab_content_' + file_id).style.display = 'flex';

	} else {

		doc.getElementById('cotton_tab_' + file_id).className = 'cotton-tab-item-active';
		doc.getElementById('cotton_tab_content_' + file_id).style.display = 'flex';

	}

	active_tab_id = file_id;

	if (active_tab_id) {
	
		populate_menu_actions('tab', doc.getElementById('cotton_tab_' + active_tab_id).dataset.editor);
		doc.getElementById('cotton_input').value = doc.getElementById('cotton_tab_' + active_tab_id).dataset.path + doc.getElementById('cotton_tab_' + active_tab_id).dataset.name;
		
		doc.getElementById('cotton_menu_view').style.display = 'none';

	} else {

		doc.getElementById('cotton_menu_view').style.display = 'block';

		doc.getElementById('cotton_input').value = doc.getElementById('folder_' + active_folder_id).dataset.path;

		if (active_folder_id) {
		
			populate_menu_actions('archive');

		} else {

			populate_menu_actions('trash');

		}

	}

}

function close_tab (file_id) {

	doc.getElementById('cotton_tab_' + file_id).remove();
	doc.getElementById('cotton_tab_content_' + file_id).remove();
	
	if (active_tab_id == file_id) {

		let last_tab = doc.getElementById('cotton_tabs_list').lastChild;
		
		if (typeof(last_tab.dataset) != 'undefined') {
			
			active_tab_id = last_tab.dataset.id;

		} else {

			active_tab_id = 0;

		}

		switch_tab(active_tab_id);

	}
	
}

function select_item (item_id, item_type) {

	let type_view = '',
		type_row = '';

	if (!view_items_type) {

		type_view = '-list';
		type_row = 'row ';

	}

	if ((active_item.id != 0) && (active_item.type != '')) {

		if (doc.getElementById(`item_${active_item.type}_${active_item.id}`).className == `${type_row}cotton-item${type_view}-selected`) {

			doc.getElementById(`item_${active_item.type}_${active_item.id}`).className = `${type_row}cotton-item${type_view}`;

		}

	}
	
	if (doc.getElementById(`item_${item_type}_${item_id}`).className = `${type_row}cotton-item${type_view}`) {

		doc.getElementById(`item_${item_type}_${item_id}`).className = `${type_row}cotton-item${type_view}-selected`;

	}

	active_item = doc.getElementById(`item_${item_type}_${item_id}`).dataset;

	if (doc.getElementById('cotton_item_view').style.display == 'block') {

		show_item_object('view');

	}

}

function show_btn_actions_over (item_id, item_type) {

	if (view_items_type) {
	
		doc.getElementById(`btn_${item_type}_actions_${item_id}`).className = 'cotton-item-actions-grid-block';

	} else {

		doc.getElementById(`btn_${item_type}_actions_${item_id}`).className = 'cotton-item-actions-block';

	}



}

function show_btn_actions_leave (item_id, item_type) {

	switch (item_type) {

		case 'folder':
			
			doc.getElementById('btn_folder_actions_' + item_id).className = 'cotton-item-actions-none';
			break;

		case 'file':

			doc.getElementById('btn_file_actions_' + item_id).className = 'cotton-item-actions-none';

			break;

	}

}

function mount_item_name (item_name, type) {

	let result = '';

	switch (type) {

		case 'item':

			if (item_name.length >= 35) {

				result = item_name.substr(0,26) + '...' + item_name.substr(item_name.length-8, 8);
		
				return result;
		
			} else {
		
				return item_name;
		
			}

			break;

		case 'tab':

			if (item_name.length >= 8) {

				result = item_name.substr(0,7) + '...';
		
				return result;
		
			} else {
		
				return item_name;
		
			}

			break;

	}
	
	if (item_name.length >= 35) {

		result = item_name.substr(0,26) + '...' + item_name.substr(item_name.length-8, 8);

		return result;

	} else {

		return item_name;

	}

}
   
function mount_file_size (file_size) {

	const units = ['B', 'KB', 'MB', 'GB', 'TB', 'PB', 'EB', 'ZB', 'YB'];

	let l = 0, n = parseInt(file_size, 10) || 0;

	while( n >= 1024 && ++l) {
	
		n = n/1024;
	
	}

	return(n.toFixed(n < 10 && l > 0 ? 1 : 0) + ' ' + units[l]);

}

function show_item_view () {

	let html = '';
	
	if (doc.getElementById('cotton_item_view').style.display == 'block') {

		doc.getElementById('view_info_item').className = 'btn btn-secondary btn-sm';
		doc.getElementById('cotton_item_view').style.display = 'none';
		doc.getElementById('cotton_items').className = 'row col-md-10';

	} else {

		doc.getElementById('view_info_item').className = 'btn btn-dark btn-sm';
		doc.getElementById('cotton_items').className = 'row col-md-7';
		doc.getElementById('cotton_item_view').style.display = 'block';
		
	}

	show_item_object('view');

}

function show_item_object (info_type) {

	let tab_content = '',
		tab_info = '',
		html = '';

	if (active_item.id != 0) {
	
		switch (active_item.type) {

			case 'folder':

				let btn_open_folder = '';

				if (active_item.id) {
						
					if (active_folder_id) {
					
						btn_open_folder = `<nav>
												<span style="float: right;">
													<button type="button" class="btn btn-success btn-sm" onclick="folder_click_open();" title="${Joomla.JText._('COM_COTTON_OPEN_FOLDER')}">
													<span class="icon-forward-2"></span>
													</button>
												</span>
											</nav>`;

					}

					html = `<header class="cotton-view-header">
								<span class="icon-folder cotton-icon-folder cotton-view-icon" title="${active_item.folder_name}"></span>
							</header>
							${btn_open_folder}
							<section>
								<div class="cotton-info-label">${Joomla.JText._('COM_COTTON_NAME')}</div>
								<div id="info_${info_type}_name_${active_item.id}" class="cotton-info">${active_item.folder_name}</div>
								<div class="cotton-info-label">${Joomla.JText._('COM_COTTON_ITEMS')}</div>
								<div class="cotton-info">${active_item.folder_n_folders} ${Joomla.JText._('COM_COTTON_FOLDERS')} / ${active_item.folder_n_files} ${Joomla.JText._('COM_COTTON_FILES')}</div>
								<div class="cotton-info-label">Description</div>
								<div id="info_${info_type}_description_${active_item.id}" class="cotton-info">${active_item.folder_description}</div>
							</section>`;
				}

				break;

			case 'file':

				if (active_item.id) {

					let allowed_users = JSON.parse(active_item.file_allowed_users),
						btn_open_file = '';
					
					if (active_folder_id) {

						btn_open_file = `<nav>
											<span style="float: right;"><button class="btn btn-primary btn-sm" type="button" onclick="create_tab();"><span class="icon-new-tab" title="${Joomla.JText._('COM_COTTON_OPEN_FILE')}"></span></button></span>
										 </nav>`;

					}
					
					icon_open_link = mount_open_link_info (active_item.file_open_link, allowed_users);

					let file_size = mount_file_size(active_item.file_size),
						file_type = get_type(get_ext(active_item.file_name)),
						mime_type = active_item.file_mime_type.split('/');

					tab_info = `<div class="cotton-info-label">${Joomla.JText._('COM_COTTON_NAME')}</div>
								<div id="info_${info_type}_file_name_${active_item.id}" class="cotton-info">${active_item.file_name}</div>
								<div class="cotton-info-label">${Joomla.JText._('COM_COTTON_SHARED_LINK')}</div>
								<div id="info_${info_type}_file_open_link_${active_item.id}" class="cotton-info">${icon_open_link}</div>
								<div class="cotton-info-label">${Joomla.JText._('COM_COTTON_SIZE')}</div>
								<div class="cotton-info">${file_size}</div>
								<div class="cotton-info-label">${Joomla.JText._('COM_COTTON_DESCRIPTION')}</div>
								<div id="info_${info_type}_file_description_${active_item.id}" class="cotton-info">${active_item.file_description}</div>`;
								
					switch (file_type) {
						
						case 'image':

							let max_height = '';
						
							if (info_type != 'tab') {

								max_height = 'style="max-height: 270px;"';
					
							}

							tab_content = `<img src="${uri_root_cotton}index.php?option=com_cotton&view=cotton&task=cotton.open&format=json&file_id=${active_item.id}" alt="${active_item.file_name}" ${max_height}>`;

							html = `<header style="display: grid;justify-items: center;">
										${tab_content}
									</header>
									${btn_open_file}
									<section>
										${tab_info}
									</section>`;
							break;

						case 'video':

							tab_content = `<video class="cotton-video-player" controls>
											  <source src="${uri_root_cotton}index.php?option=com_cotton&view=cotton&task=cotton.open&format=json&file_id=${active_item.id}" type="${active_item.file_mime_type}">
										   </video>`;
						
							html = `<header>
										${tab_content}
									</header>
									${btn_open_file}
									<section>
										${tab_info}
									</section>`;
							break;

						case 'audio':

							tab_content = `<audio class="cotton-audio-player" controls>
											  <source src="${uri_root_cotton}index.php?option=com_cotton&view=cotton&task=cotton.open&format=json&file_id=${active_item.id}" type="${active_item.file_mime_type}">
										   </audio>`;
							html = `<header>
										${tab_content}
									</header>
									${btn_open_file}
									<section>
										${tab_info}
									</section>`;
							break;

						case 'text':
							
							html = `<header class="cotton-view-header">
										<span class="icon-file cotton-view-icon"></span>
									</header>
									${btn_open_file}
									<section>
										${tab_info}
									</section>`;
							break;

						case 'other':

							let icon_other = '';
						
							if (mime_type[0] != 'text') {

								tab_content = `<div class="cotton-alert-no-app">
												  <h2 class="icon-smiley-sad"></h2>
												  <h4>${Joomla.JText._('COM_COTTON_NO_APP')}</h4>
											   </div>`;

								icon_other = '<span class="icon-cube cotton-view-icon cotton-icon-app"></span>';

							} else {

								icon_other = '<span class="icon-file cotton-view-icon"></span>';

							}

							html = `<header class="cotton-view-header">
										${icon_other}
									</header>
									${btn_open_file}
									<section>
										${tab_info}
									</section>`;
							break;

				}
				
				break;

			}

		}

		active_item.content = tab_content;
		active_item.info = tab_info;

		if (info_type != 'tab') {

			doc.getElementById('cotton_item_view').innerHTML = html;

		}

	} else {

		doc.getElementById('cotton_item_view').innerHTML = `<main>
																<div class="cotton-alert-no-app">${Joomla.JText._('COM_COTTON_NO_ITEM')}</div>
															</main>`;
															
	}

}

function mount_open_link_info (open_link, allowed_users) {

	switch (open_link) {

		case '0':

			if (allowed_users.length) {
					
				icon_open_link = `<span class="icon-user-circle cotton-icon-link" title="${Joomla.JText._('COM_COTTON_SPECIFIC_USERS')}"></span>
								  <span>${Joomla.JText._('COM_COTTON_SPECIFIC_USERS')}</span>`;
		
			} else {

				icon_open_link = `<span>${Joomla.JText._('COM_COTTON_NO')}</span>`;

			}

			break;

		case '1':
			
			icon_open_link = `<span class="icon-users cotton-icon-link" title="${Joomla.JText._('COM_COTTON_REGISTERED_USERS')}"></span>
							  <span>${Joomla.JText._('COM_COTTON_REGISTERED_USERS')}</span>`;
			break;

		case '2':
			
			icon_open_link = `<span class="icon-link cotton-icon-link" title="${Joomla.JText._('COM_COTTON_ALL_USERS')}"></span>
							  <span>${Joomla.JText._('COM_COTTON_ALL_USERS')}</span>`;
			break;

	}

	return icon_open_link;

}

function change_items_view () {

	switch (view_items_type) {

		case 0:
			doc.getElementById('view_type_items').className = 'icon-list';
			view_items_type = 1;

			doc.getElementById('cotton_items').style.display = 'flex';
			doc.getElementById('cotton_items').style.padding = '5px';
			doc.getElementById('cotton_items').innerHTML = populate_items(cotton_data.folders, cotton_data.files);

			break;

		case 1:
			doc.getElementById('view_type_items').className = 'icon-grid';
			view_items_type = 0;

			doc.getElementById('cotton_items').style.display = 'block';
			doc.getElementById('cotton_items').style.padding = '0px';
			doc.getElementById('cotton_items').innerHTML = populate_items(cotton_data.folders, cotton_data.files);

			break;

	}

	if (active_item.id != 0) {

		select_item(active_item.id, active_item.type);

	}

}

function form_file_options () {

	let file_id = active_item.id,
		file_name = active_item.file_name,
		file_description = active_item.file_description,
		file_open_link = active_item.file_open_link;
		file_allowed_users = active_item.file_allowed_users;
	
	if (active_tab_id) {

		file_id = doc.getElementById('cotton_tab_' + active_tab_id).dataset.id;
		file_name = doc.getElementById('cotton_tab_' + active_tab_id).dataset.name;
		file_description = doc.getElementById('cotton_tab_' + active_tab_id).dataset.description;
		file_open_link = doc.getElementById('cotton_tab_' + active_tab_id).dataset.open_link;
		file_allowed_users = doc.getElementById('cotton_tab_' + active_tab_id).dataset.allowed_users;

	}
	
	const form = doc.createElement("section");

	form.id = "form_file_options";
	form.className = "cotton-form"
	form.innerHTML = `<header class="cotton-form-header">
						<span class="icon-options"></span>
						<span>${Joomla.JText._('COM_COTTON_FILE_OPTIONS')}</span>
					  </header>
					  <div class="cotton-form-content">
					  	<div class="cotton-form-item-content">
							<label for="form_file_name"><span>${Joomla.JText._('COM_COTTON_FILE_NAME')}</span></label>
							<span><input id="form_file_name" type="text" class="cotton-input" maxlength="255" value="${file_name}"></span>
						</div>
						<div class="cotton-form-item-content row">
							<div class="col-md-5">
								<label for="form_shared_link"><span>Shared Link</span></label>
								<input id="form_shared_link" type="checkbox">
							</div>
							<div id ="form_shared_radio" class="col-md-7" hidden>
								<div>
									<input id="form_shared_users" name="form_shared_open" type="radio" value="1" checked>
									<span>${Joomla.JText._('COM_COTTON_REGISTERED_USERS')}</span>
								</div>
								<div>
									<input id="form_shared_all" name="form_shared_open" type="radio" value="2">
									<span>${Joomla.JText._('COM_COTTON_ALL_USERS')}</span>
								</div>
							</div>
						</div>
						<div class="cotton-form-item-content">
							<label for="form_allowed_users">
								<span>${Joomla.JText._('COM_COTTON_SPECIFIC_USERS')}</span>
								<span class="icon-info-2" title="${Joomla.JText._('COM_COTTON_SPECIFIC_USERS_INFO')}"></span>
							</label>
							<span><input id="form_allowed_users" type="text" class="cotton-input"></span>
						</div>
						<div class="cotton-form-item-content">
							<label for="form_link"><span>Link</span></label>
							<span><input id="form_link" type="text" class="cotton-input" disabled></span>

							<button type="button" class="btn btn-secondary btn-sm" onclick="copy_link(${file_id});">
								<span class="icon-copy"></span>
								<span>${Joomla.JText._('COM_COTTON_COPY_LINK')}</span>
							</button>
						</div>
						<div class="cotton-form-item-content">
							<label for="form_file_description"><span>${Joomla.JText._('COM_COTTON_DESCRIPTION')}</span></label>
							<textarea id="form_file_description" rows="3" cols="40" class="cotton-text">${file_description}</textarea>
						</div>
					  </div>
					  <footer class="cotton-form-footer">
						<button type="button" class="btn btn-danger btn-sm" onclick="screen_cancel();">${Joomla.JText._('COM_COTTON_CANCEL')}</button>
						<button type="button" class="btn btn-success btn-sm" onclick="file_options_update();">${Joomla.JText._('COM_COTTON_UPDATE')}</button>
					  </footer>`;
	
	doc.getElementById('cotton_screen').appendChild(form);

	doc.getElementById('form_link').value = uri_root_cotton + 'index.php?option=com_cotton&view=cotton&task=cotton.open&format=json&file_id=' + file_id;
	
	file_allowed_users = JSON.parse(file_allowed_users);
	doc.getElementById('form_allowed_users').value = file_allowed_users.join(', ');

	switch (file_open_link) {

		case '0':
			doc.getElementById('form_shared_link').checked = false;
			doc.getElementById('form_shared_radio').hidden = true;
			break;
		case '1':
			doc.getElementById('form_shared_link').checked = true;
			doc.getElementById('form_shared_users').checked = true;
			doc.getElementById('form_shared_radio').removeAttribute('hidden');
			break;
		case '2':
			doc.getElementById('form_shared_link').checked = true;
			doc.getElementById('form_shared_all').checked = true;
			doc.getElementById('form_shared_radio').removeAttribute('hidden');
			break;

	}

	doc.getElementById('form_shared_link').addEventListener('change', function() {
																			
																				if (doc.getElementById('form_shared_link').checked) {

																					doc.getElementById('form_shared_radio').removeAttribute('hidden');

																				} else {

																					doc.getElementById('form_shared_radio').hidden = true;

																				}
																			});
	

	doc.getElementById('cotton_screen').style.display = "grid";
	doc.getElementById('form_file_name').focus;

}

function file_options_update () {

	let file_id = active_item.id,
		file_name = active_item.file_name,
		file_description = active_item.file_description,
		file_open_link = active_item.file_open_link,
		file_allowed_users = active_item.file_allowed_users,
		form_file_name = doc.getElementById('form_file_name').value,
		form_id = 'form_file_options',
		form_title = Joomla.JText._('COM_COTTON_FOLDER_OPTIONS_ERROR');

	form_file_name = form_file_name.trim();
	
	if (active_tab_id) {

		file_id = doc.getElementById('cotton_tab_' + active_tab_id).dataset.id;
		file_name = doc.getElementById('cotton_tab_' + active_tab_id).dataset.name;
		file_description = doc.getElementById('cotton_tab_' + active_tab_id).dataset.description;
		file_open_link = doc.getElementById('cotton_tab_' + active_tab_id).dataset.open_link;
		file_allowed_users = doc.getElementById('cotton_tab_' + active_tab_id).dataset.allowed_users;

	}

	let up = false,
		error = false,
		args = new Object();

	args.file_id = file_id;

	if (file_name == form_file_name) {

		args.file_name = file_name;

	} else {

		args.file_name = form_file_name;
		up = true;

	}

	if (file_description == doc.getElementById('form_file_description').value) {

		args.file_description = file_description;

	} else {

		args.file_description = doc.getElementById('form_file_description').value.trim();
		args.file_description = args.file_description.replace(/<[^>]*>/g, '');
		args.file_description = args.file_description.replace(/[\\"]/g, '');

		up = true;

	}
	
	if (doc.getElementById('form_shared_link').checked) {

		if (doc.getElementById('form_shared_users').checked) {

			args.file_open_link = 1;

		}
		
		if (doc.getElementById('form_shared_all').checked) {

			args.file_open_link = 2;

		}

	} else {

		args.file_open_link = 0;

	}
	
	if (args.file_open_link != parseInt(file_open_link)) {

		up = true;

	}

	let allowed_users = doc.getElementById('form_allowed_users').value;

	allowed_users = allowed_users.replace(' ', '');
	allowed_users = '[' + allowed_users + ']';
	
	if (file_allowed_users == allowed_users) {
		
		args.file_allowed_users = file_allowed_users;

	} else {

		args.file_allowed_users = allowed_users;
		up = true;

	}

	if (form_file_name == '') {

		form_error(form_id, form_title, Joomla.JText._('COM_COTTON_FILENAME_EMPTY'));
		error = true;

	} else {

		if (!valid_file_name(form_file_name)) {

			form_error(form_id, form_title, Joomla.JText._('COM_COTTON_FILENAME_INVALID'));
			error = true;

		} else {

			let list_names = [];

			for (let i = 0; i < cotton_data.files.length; i++) {

				if (cotton_data.files[i].id != file_id)  {
				
					list_names.push(cotton_data.files[i].name);

				}

			}

			if (list_names.includes(form_file_name)) {

				form_error(form_id, form_title, Joomla.JText._('COM_COTTON_FILENAME_EXISTS'));
				error = true;

			}

		}

	}
	
	if (up && !error) {

		data_cotton('file_update', args);

	} else if (!up && !error) {

		screen_cancel();

	}

}

function valid_file_name (file_name) {

	let rg1=/^[^\\/:\*\?"<>\|]+$/; // forbidden characters \ / : * ? " < > |
  	let rg2=/^\./; // cannot start with dot (.)
  	let rg3=/^(nul|prn|con|lpt[0-9]|com[0-9])(\.|$)/i; // forbidden file names

	return rg1.test(file_name) && !rg2.test(file_name) && !rg3.test(file_name);

}

function valid_folder_name (folder_name) {

	let reg = /^[^\s^\x00-\x1f\\?*:"";<>|\/.][^\x00-\x1f\\?*:"";<>|\/]*[^\s^\x00-\x1f\\?*:"";<>|\/.]+$/g;

	return reg.test(folder_name);

}

function form_folder_options () {

	const form = doc.createElement("section");

	form.id = "form_folder_options";
	form.className = "cotton-form"
	form.innerHTML = `<header class="cotton-form-header">
						<span class="icon-options"></span>
						<span>${Joomla.JText._('COM_COTTON_FOLDER_OPTIONS')}</span>
					  </header>
					  <div class="cotton-form-content">
					  	<div class="cotton-form-item-content">
							<label for="form_folder_name"><span>${Joomla.JText._('COM_COTTON_FOLDER_NAME')}</span></label>
							<input id="form_folder_name" type="text" class="cotton-input" maxlength="255" value="${active_item.folder_name}">
						</div>
						<div class="cotton-form-item-content">
							<label for="form_folder_description"><span>${Joomla.JText._('COM_COTTON_DESCRIPTION')}</span></label>
							<span><textarea id="form_folder_description" rows="3" cols="44" class="cotton-text">${active_item.folder_description}</textarea></span>
						</div>
					  </div>
					  <footer class="cotton-form-footer">
						<button type="button" class="btn btn-danger btn-sm" onclick="screen_cancel();">${Joomla.JText._('COM_COTTON_CANCEL')}</button>
						<button type="button" class="btn btn-success btn-sm" onclick="folder_options_update(${active_item.id}, '${active_item.folder_name}', '${active_item.folder_description}');">${Joomla.JText._('COM_COTTON_UPDATE')}</button>
					  </footer>`;
	
	doc.getElementById('cotton_screen').appendChild(form);
	doc.getElementById('cotton_screen').style.display = "grid";
	doc.getElementById('form_folder_name').focus;

}

function folder_options_update (folder_id, folder_name, folder_description) {

	let up = false,
		error = false,
		args = new Object(),
		form_id = 'form_folder_options',
		form_title = Joomla.JText._('COM_COTTON_FOLDEROPTIONS_ERROR'),
		form_folder_name = doc.getElementById('form_folder_name').value;
		
	form_folder_name = form_folder_name.trim();

	args.folder_id = folder_id;

	if (folder_name == form_folder_name) {

		args.folder_name = folder_name;

	} else {

		args.folder_name = form_folder_name;
		up = true;

	}

	if (folder_description == doc.getElementById('form_folder_description').value) {

		args.folder_description = folder_description;

	} else {

		args.folder_description = doc.getElementById('form_folder_description').value.trim();
		args.folder_description = args.folder_description.replace(/<[^>]*>/g, '');
		args.folder_description = args.folder_description.replace(/[\\"]/g, '');

		up = true;

	}

	if (form_folder_name == '') {

		form_error(form_id, form_title, Joomla.JText._('COM_COTTON_FOLDERNAME_EMPTY'));
		error = true;

	} else {

		if (!valid_folder_name(form_folder_name)) {

			form_error(form_id, form_title, Joomla.JText._('COM_COTTON_FOLDERNAME_INVALID'));
			error = true;

		} else {

			let list_names = [];

			for (let i = 0; i < cotton_data.folders.length; i++) {

				if (cotton_data.folders[i].id != folder_id)  {
				
					list_names.push(cotton_data.folders[i].name);

				}

			}

			if (list_names.includes(form_folder_name)) {

				form_error(form_id, form_title, Joomla.JText._('COM_COTTON_FOLDERNAME_EXISTS'));
				error = true;

			}

		}

	}

	if (up && !error) {

		data_cotton('folder_update', args);

	} else if (!up && !error) {

		screen_cancel();

	}

}

function copy_link (file_id) {

	let link = uri_root_cotton + 'index.php?option=com_cotton&view=cotton&task=cotton.open&format=json&file_id=' + file_id;
	
	navigator.clipboard.writeText(link);

}

function form_item_delete () {

	let item_id = active_item.id,
		item_type = active_item.type,
		item_name = active_item.file_name;
		form_title = '',
		ask_text = '';

	if (active_tab_id) {

		item_id = doc.getElementById('cotton_tab_' + active_tab_id).dataset.id;
		item_type = doc.getElementById('cotton_tab_' + active_tab_id).dataset.type;
		item_name = doc.getElementById('cotton_tab_' + active_tab_id).dataset.name;

	}

	switch (item_type) {

		case 'folder':

			form_title = Joomla.JText._('COM_COTTON_DELETE_FOLDER');
			ask_text = Joomla.JText._('COM_COTTON_DELETE_FILE_CONFIRM');
			break;

		case 'file':

			form_title = Joomla.JText._('COM_COTTON_DELETE_FILE');
			ask_text = Joomla.JText._('COM_COTTON_DELETE_FILE_CONFIRM');
			break;

	}
	
	const form = doc.createElement("section");

	form.id = "form_item_delete";
	form.className = "cotton-form"
	form.innerHTML = `<header class="cotton-form-header">
						<span class="icon-trash"></span>
						<span>${form_title}</span>
					  </header>
					  <div class="cotton-form-content">
						<div class="cotton-form-item-content">${item_name}</div>
						<div  class="cotton-form-item-content">${ask_text}</div>
						<div>
							<label for="form_trash">${Joomla.JText._('COM_COTTON_TRASH')}</label>
							<input id="form_trash" type="checkbox" checked>
						</div>
					  </div>
					  <footer class="cotton-form-footer">
						<button type="button" class="btn btn-danger btn-sm" onclick="screen_cancel();">${Joomla.JText._('COM_COTTON_CANCEL')}</button>
						<button type="button" class="btn btn-success btn-sm" onclick="item_delete(${item_id}, '${item_type}');">${Joomla.JText._('COM_COTTON_DELETE')}</button>
					  </footer>`;
	
	doc.getElementById('cotton_screen').appendChild(form);
	doc.getElementById('cotton_screen').style.display = "grid";

}

function item_delete (item_id, item_type) {
	
	let args = new Object();

	args.item_id = item_id;
	args.item_type = item_type;
	
	if (doc.getElementById('form_trash').checked) {

		args.trash = 1;

	} else {

		args.trash = 0;

	}

	data_cotton('item_delete', args);

}

function form_clear_trash () {

	const form = doc.createElement("section");

	form.id = "form_clear_trash";
	form.className = "cotton-form"
	form.innerHTML = `<header class="cotton-form-header">
						<span class="icon-trash"></span>
						<span>${Joomla.JText._('COM_COTTON_TRASH_CLEAR')}</span>
					  </header>
					  <div class="cotton-form-content">
						<div>${Joomla.JText._('COM_COTTON_TRASH_CLEAR_ALL')}</div>
					  </div>
					  <footer class="cotton-form-footer">
						<button type="button" class="btn btn-danger btn-sm" onclick="screen_cancel();">${Joomla.JText._('COM_COTTON_CANCEL')}</button>
						<button type="button" class="btn btn-success btn-sm" onclick="data_cotton('clear_trash');">${Joomla.JText._('COM_COTTON_CLEAR')}</button>
					  </footer>`;
	
	doc.getElementById('cotton_screen').appendChild(form);
	doc.getElementById('cotton_screen').style.display = "grid";

}

function form_item_recover (item_id, item_type, item_name) {

	let list_html = populate_list(cotton_data.list, 0, true);
	
	const form = doc.createElement("section");

	form.id = "form_item_recover";
	form.className = "cotton-form"
	form.innerHTML = `<header class="cotton-form-header">
						<span class="icon-arrow-up-4"></span>
						<span>${Joomla.JText._('COM_COTTON_RECOVER_ITEM')}</span>
					  </header>
					  <div class="cotton-form-content">
					  	<div>${item_name}</div>
					  	<div>${Joomla.JText._('COM_COTTON_RECOVER_SELECT')}</div>
						<div class="cotton-form-folder-list">
							${list_html}
						</div>
					  </div>
					  <footer class="cotton-form-footer">
						<button type="button" class="btn btn-danger btn-sm" onclick="screen_cancel();">${Joomla.JText._('COM_COTTON_CANCEL')}</button>
						<button type="button" class="btn btn-success btn-sm" onclick="item_recover(${item_id}, '${item_type}', '${item_name}');">${Joomla.JText._('COM_COTTON_RECOVER')}</button>
					  </footer>`;
	
	doc.getElementById('cotton_screen').appendChild(form);
	doc.getElementById('cotton_screen').style.display = "grid";

}

function item_recover (item_id, item_type, item_name) {

	let form_id = 'form_item_recover',
		form_title = Joomla.JText._('COM_COTTON_RECOVER_ERROR'),
		args = [];
	
	args.item_id = item_id;
	args.item_type = item_type;
	args.item_name = item_name;
	
	if (folder_selected !== null) {

		if (folder_selected) {
		
			args.folder_id = folder_selected;
			data_cotton("item_recover", args);

		} else {

			screen_cancel();

		}

	} else {

		form_error(form_id, form_title, Joomla.JText._('COM_COTTON_RECOVER_NOFOLDER'));

	}

}

function form_file_create () {

	const form = doc.createElement("section");

	form.id = "form_file_create";
	form.className = "cotton-form"
	form.innerHTML = `<header class="cotton-form-header">
						<span class="icon-file"></span>
						<span>Create File</span>
					  </header>
					  <div class="cotton-form-content">
					  	<label for="form_file_name">File Name</label>
						<input id="form_file_name" type="text" class="cotton-input">
					  </div>
					  <div class="cotton-form-content">
						<label for="form_file_description"><span>${Joomla.JText._('COM_COTTON_DESCRIPTION')}</span></label>
						<span><textarea id="form_file_description" rows="3" cols="44" class="cotton-text"></textarea></span>
					  </div>
					  <footer class="cotton-form-footer">
						<button type="button" class="btn btn-danger btn-sm" onclick="screen_cancel();">${Joomla.JText._('COM_COTTON_CANCEL')}</button>
						<button type="button" class="btn btn-success btn-sm" onclick="file_create();">${Joomla.JText._('COM_COTTON_CREATE')}</button>
					  </footer>`;
	
	doc.getElementById('cotton_screen').appendChild(form);
	doc.getElementById('cotton_screen').style.display = "grid";
	doc.getElementById('form_file_name').focus;

}

function file_create () {

	let args = new Object(),
		error = false,
		form_id = 'form_file_create',
		form_title = Joomla.JText._('COM_COTTON_CREATEFILE_ERROR'),
		file_name = doc.getElementById('form_file_name').value.trim();
	
	args.folder_id = active_folder_id;
	args.file_description = doc.getElementById('form_file_description').value.trim();
	args.file_description = args.file_description.replace(/<[^>]*>/g, '');
	args.file_description = args.file_description.replace(/[\\"]/g, '');

	if (file_name == '') {

		form_error(form_id, form_title, Joomla.JText._('COM_COTTON_FILENAME_EMPTY'));
		error = true;

	} else if (!valid_file_name(file_name)) {

		form_error(form_id, form_title, Joomla.JText._('COM_COTTON_FILENAME_INVALID'));
		error = true;

		} else {

			let list_names = [];

			if (cotton_data.n_files) {
			
				for (let i = 0; i < cotton_data.files.length; i++) {
					
					list_names.push(cotton_data.files[i].name);

				}

				if (list_names.includes(file_name)) {

					form_error(form_id, form_title, Joomla.JText._('COM_COTTON_FILENAME_EXISTS'));
					error = true;

				}

			}

		}

	if (!error) {

		args.file = new File([''], file_name);
		args.file_name = file_name;
	
		data_cotton("file_create", args);

	}

}

function form_folder_create () {

	const form = doc.createElement("section");

	form.id = "form_folder_create";
	form.className = "cotton-form"
	form.innerHTML = `<header class="cotton-form-header">
						<span class="icon-folder cotton-icon-folder"></span>
						<span>${Joomla.JText._('COM_COTTON_CREATE_FOLDER')}</span>
					  </header>
					  <div class="cotton-form-content">
					  	<label for="form_folder_name">Folder Name</label>
						<input id="form_folder_name" type="text" class="cotton-input">
					  </div>
					  <div class="cotton-form-content">
						<label for="form_folder_description"><span>${Joomla.JText._('COM_COTTON_CREATEFOLDER_ERROR')}</span></label>
						<span><textarea id="form_folder_description" rows="3" cols="44" class="cotton-text"></textarea></span>
					  </div>
					  <footer class="cotton-form-footer">
						<button type="button" class="btn btn-danger btn-sm" onclick="screen_cancel();">${Joomla.JText._('COM_COTTON_CANCEL')}</button>
						<button type="button" class="btn btn-success btn-sm" onclick="folder_create();">${Joomla.JText._('COM_COTTON_CREATE')}</button>
					  </footer>`;
	
	doc.getElementById('cotton_screen').appendChild(form);
	doc.getElementById('cotton_screen').style.display = "grid";
	doc.getElementById('form_folder_name').focus;

}

function folder_create () {

	let args = new Object(),
		error = false,
		form_id = 'form_folder_create',
		form_title = Joomla.JText._('COM_COTTON_CREATEFOLDER_ERROR');
	
	args.parent_id = active_folder_id;
	args.folder_name = doc.getElementById('form_folder_name').value.trim();
	args.folder_description = doc.getElementById('form_folder_description').value.trim();
	args.folder_description = args.folder_description.replace(/<[^>]*>/g, '');
	args.folder_description = args.folder_description.replace(/[\\"]/g, '');

	
	if (args.folder_name == '') {

		form_error(form_id, form_title, Joomla.JText._('COM_COTTON_FOLDERNAME_EMPTY'));
		error = true;

	} else if (!valid_folder_name(args.folder_name)) {

		form_error(form_id, form_title, Joomla.JText._('COM_COTTON_FOLDERNAME_INVALID'));
		error = true;

		} else {

			let list_names = [];

			if (cotton_data.n_folders) {
				
				for (let i = 0; i < cotton_data.folders.length; i++) {
					
					list_names.push(cotton_data.folders[i].name);

				}

				if (list_names.includes(args.folder_name)) {

					form_error(form_id, form_title, Joomla.JText._('COM_COTTON_FOLDERNAME_EXISTS'));
					error = true;

				}

			}

		}

	if (!error) {
	
		data_cotton("folder_create", args);

	}

}

function screen_cancel () {

	doc.getElementById('cotton_screen').innerHTML = "";
	doc.getElementById('cotton_screen').style.display = "none";

}

function form_file_upload () {

	const form = doc.createElement("section");

	form.id = "form_file_upload";
	form.className = "cotton-form"
	form.innerHTML = `<header class="cotton-form-header">
						<span class="icon-folder"></span>
						<span>${Joomla.JText._('COM_COTTON_UPLOAD_FILES')}</span>
					  </header>
					  <div class="cotton-form-content">
					  	<label for="form_header_name">Files</label>
						<div id="form_select_file" style="display: block;">
							<input id="form_file" name="upload_files"
								type="file"
								class="cotton-input"
								accept="*"
								multiple>
						</div>
						<div id="form_file_upload_progress" style="display: none;" class="cotton-form-file-upload">
						</div>
					  </div>
					  <footer id="form_file_upload_footer" class="cotton-form-footer">
						<button type="button" class="btn btn-danger btn-sm" onclick="screen_cancel();">${Joomla.JText._('COM_COTTON_CANCEL')}</button>
						<button type="button" class="btn btn-success btn-sm" onclick="file_upload();">${Joomla.JText._('COM_COTTON_UPLOAD')}</button>
					  </footer>`;
	
	doc.getElementById('cotton_screen').appendChild(form);
	doc.getElementById('cotton_screen').style.display = "grid";
	doc.getElementById('form_file').focus;	

}

function file_upload () {

	let args = new Object(),
		form_title = 'File Upload Error',
		form_id = 'form_file_upload';
	
	if (doc.getElementById('form_file').files.length) {

		let up = false,
			display_btn = 'block',
			uploading = 'none';

		for (let i = 0; i < doc.getElementById('form_file').files.length; i++) {

			let icon_type = icon_file_type(doc.getElementById('form_file').files[i].name, doc.getElementById('form_file').files[i].type),
				file_name = mount_item_name(doc.getElementById('form_file').files[i].name, 'file'),
				file_size = mount_file_size(doc.getElementById('form_file').files[i].size),
				j = 0;

			const file_upload = doc.createElement('div');

			if (valid_file_size(doc.getElementById('form_file').files[i].size)) {
		
				files_upload.push(doc.getElementById('form_file').files[i]);

				j = files_upload.length - 1;

				file_upload.id = 'file_upload_' + j;
				file_upload.className = 'cotton-file-upload';
				
				file_upload.innerHTML = `<div><span class="${icon_type}"></span>
											<span>${file_name} (${file_size})</span>
											</div>
											<div id="form_progress_${j}">
												<div class="cotton-progress-b">
													<div id="file_progress_${j}" style="width: 0%;" class="cotton-progress">
													</div>
												</div>
											</div>`;

			} else {

				let max_filesize = mount_file_size(cotton_data.limits.max_filesize);

				file_upload.className = 'cotton-file-upload';
				
				file_upload.innerHTML = `<div><span class="${icon_type}"></span>
											<span>${file_name} (${file_size})</span>
											</div>
											<div>
												<strong class="cotton-icon-file">${Joomla.JText._('COM_COTTON_ERROR')}: ${Joomla.JText._('COM_COTTON_ERROR_MAX_FILESIZE')} (${max_filesize})</strong>
											</div>`;

			}
		
			doc.getElementById('form_file_upload_progress').appendChild(file_upload);

		}

		if (files_upload.length) {

			up = true;
			display_btn = 'none';
			uploading = 'block';

			args.folder_id = active_folder_id;
			args.file = files_upload[0];
			args.index = 0;

			data_cotton('file_upload', args);

		}

		doc.getElementById('form_select_file').remove();
		doc.getElementById('form_file_upload_progress').style.display = 'block';

		doc.getElementById('form_file_upload_footer').innerHTML = `<button id="form_file_uploading" type="button" class="btn btn-success btn-sm" style="display: ${uploading};" disabled>${Joomla.JText._('COM_COTTON_UPLOADING')}</button>
																	<button id="form_file_upload_btn" type="button" class="btn btn-success btn-sm" style="display: ${display_btn};" onclick="screen_cancel();">${Joomla.JText._('COM_COTTON_DONE')}</button>`;

	} else {

		form_error(form_id, form_title, Joomla.JText._('COM_COTTON_UPLOAD_NOFILE'));

	}

}

function valid_file_size (file_size) {

	if ((file_size > cotton_data.limits.max_filesize) || (file_size > max_filesize_db)) {

		return false;

	} else {

		return true;

	}

}

function system_error (title, error) {

	const form = doc.createElement("section");

	form.id = "system_error";
	form.className = "cotton-form"
	form.innerHTML = `<header class="cotton-form-header-error">
						<span class="icon-cancel"></span>
						<span>${title}</span>
					  </header>
					  <div class="cotton-form-content">
					  	<span>${error}</span>
					  </div>
					  <footer class="cotton-form-footer">
						<button type="button" class="btn btn-success btn-sm" onclick="screen_cancel();">${Joomla.JText._('COM_COTTON_OK')}</button>
					  </footer>`;

	doc.getElementById('cotton_screen').style.display = 'grid';
	doc.getElementById('cotton_screen').appendChild(form);

}

function form_error (form_id, form_title, form_error) {

	const form = doc.createElement("section");

	form.id = "form_error";
	form.className = "cotton-form"
	form.innerHTML = `<header class="cotton-form-header-error">
						<span class="icon-cancel"></span>
						<span>${form_title}</span>
					  </header>
					  <div class="cotton-form-content">
					  	<span>${form_error}</span>
					  </div>
					  <footer class="cotton-form-footer">
						<button type="button" class="btn btn-success btn-sm" onclick="escape_error('${form_id}');">${Joomla.JText._('COM_COTTON_OK')}</button>
					  </footer>`;

	doc.getElementById(form_id).style.display = 'none';
	doc.getElementById('cotton_screen').appendChild(form);

}

function escape_error (form_id) {

	doc.getElementById('form_error').remove();
	doc.getElementById(form_id).style.display = 'block';

}

function file_download (file_id, file_name) {

	let args = [];
	
	args.file_id = file_id;
	args.file_name = file_name;

	download_file_name = file_name;

	data_cotton("download", args);

}

function download (file) {

	const link = doc.createElement('a');
	const url = URL.createObjectURL(file);
  
	link.href = url;
	link.download = download_file_name;
	link.style.display = 'none';
	doc.body.appendChild(link);
	link.click();
  
	doc.body.removeChild(link);
	window.URL.revokeObjectURL(url);

}

function populate_footer () {

	let used_space = mount_file_size(cotton_data.limits.used_space + cotton_data.limits.trash_used_space),
		limit_space = mount_file_size(cotton_data.limits.limit_space);

	if (cotton_data.limits.limit_space == 0) {

		limit_space = "\u221E"

	}

	doc.getElementById('footer_b').innerHTML = `<span class="icon-database"></span>
												<span>${used_space} / ${limit_space}</span>`;

}
