<?php
/**
 * @package Tabaoca.Component.Cotton.Administrator
 * @subpackage com_cotton
 * @copyright (C) 2024 Jonatas C. Ferreira
 * @license GNU/AGPL v3 https://www.gnu.org/licenses/agpl-3.0.html
 */

namespace Tabaoca\Component\Cotton\Administrator\Controller;

\defined('_JEXEC') or die;

use Joomla\CMS\MVC\Controller\BaseController;
use Joomla\CMS\Factory;
use Joomla\CMS\Session\Session;
use Joomla\CMS\Response\JsonResponse;
use Joomla\CMS\Language\Text;

/**
 * Controller of Cotton Cloud System administrator component
 *
 * @package     Tabaoca.Component.Cotton.Administrator
 * @subpackage  com_cotton
 * @since       1.0.0
 */
class CottonController extends BaseController {

	/**
	* Method to start the loop to refresh data in Dashboard View.
	* 
	* @return  object  Response JSON encoded object to XHR call.
	* @since   1.0.0
	*/
	public function run () {

		try {

			if (!Session::checkToken()) {

				echo new JsonResponse(null, Text::_('JINVALID_TOKEN'), true);

			} else {

				$input = Factory::getApplication()->input;

				$n_folders = $input->get('n_folders', 0, 'INT');
				$n_files = $input->get('n_files', 0, 'INT');
				$n_size = $input->get('n_size', 0, 'INT');

				$model = $this->getModel();

				$record = $model->run($n_folders, $n_files, $n_size);

				echo new JsonResponse($record);

			}

		} catch (Exception $e) {

			echo new JsonResponse($e);

		}

	}

}
